/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.assertion.spring.config;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.munit.api.spring.config.parsers.MunitDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public abstract class AbstractAssertModuleNamespaceHandler
extends NamespaceHandlerSupport {
    private Map<String, MunitDefinitionParser> parsers = new HashMap<String, MunitDefinitionParser>();

    protected static List<String> asList(String ... attrs) {
        return Arrays.asList(attrs);
    }

    protected void declareBeanDefinitionParser(String elementName, MunitDefinitionParser parser) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)elementName), (Object)"The element name must not be blank");
        Preconditions.checkNotNull((Object)parser, (Object)"The parsers must not be null");
        this.parsers.put(elementName, parser);
    }

    protected abstract void declareBeanDefinitionParsers();

    public Map<String, MunitDefinitionParser> getParsers() {
        HashMap<String, MunitDefinitionParser> parsers = new HashMap<String, MunitDefinitionParser>();
        parsers.putAll(this.parsers);
        return parsers;
    }

    public void init() {
        this.declareBeanDefinitionParsers();
        Preconditions.checkArgument((null != this.parsers && !this.parsers.isEmpty() ? 1 : 0) != 0, (Object)"The Munit Assert Parsers haven't been defined");
        for (String elementName : this.parsers.keySet()) {
            this.registerBeanDefinitionParser(elementName, (BeanDefinitionParser)this.parsers.get(elementName));
        }
    }
}

