/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.spring.config.document;

import org.apache.xerces.parsers.DOMParser;
import org.springframework.beans.factory.xml.DefaultDocumentLoader;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * <p>
 * We change the document loader in order to get the line numbers as element attribute.
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.4
 */

public class MunitDocumentLoader extends DefaultDocumentLoader {

    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    private DOMParser munitDomParser;

    public MunitDocumentLoader(DOMParser munitDomParser) {
        checkNotNull(munitDomParser, "The dom parsers must not be null.");
        this.munitDomParser = munitDomParser;
    }

    public Document loadDocument(InputSource inputSource, EntityResolver entityResolver,
                                 ErrorHandler errorHandler, int validationMode, boolean namespaceAware) throws Exception {

        DOMParser xmlReader = this.munitDomParser;
        xmlReader.setFeature("http://xml.org/sax/features/validation", Boolean.TRUE);
        xmlReader.setFeature("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        xmlReader.setFeature("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
        xmlReader.setFeature("http://apache.org/xml/features/xinclude", Boolean.FALSE);
        xmlReader.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);

        xmlReader.setEntityResolver(entityResolver);
        xmlReader.setErrorHandler(errorHandler);

        xmlReader.parse(inputSource);

        return xmlReader.getDocument();
    }

}





