/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.spring.config;


import org.mule.munit.api.spring.config.parsers.MunitDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;
import static org.apache.commons.lang.StringUtils.isNotBlank;


/**
 * <p>
 * Mock Module Namespace Handler
 * </p>
 *
 * @author Mulesoft Inc.
 */
public abstract class AbstractMockNamespaceHandler extends NamespaceHandlerSupport {
    private Map<String, MunitDefinitionParser> parsers = new HashMap<>();


    protected static List<String> asList(String... attrs) {
        return Arrays.asList(attrs);
    }

    protected void declareBeanDefinitionParser(String elementName, MunitDefinitionParser parser) {
        checkArgument(isNotBlank(elementName), "The element name must not be blank");
        checkNotNull(parser, "The parsers must not be null");

        parsers.put(elementName, parser);
    }

    /**
     * This method is meant to be used to declare all the definition parsers that are going to be aferward registered
     */
    protected abstract void declareBeanDefinitionParsers();


    public Map<String, MunitDefinitionParser> getParsers() {
        Map<String, MunitDefinitionParser> parsers = new HashMap<>();
        parsers.putAll(this.parsers);

        return parsers;
    }

    public void init() {
        declareBeanDefinitionParsers();

        checkArgument(null != parsers && !parsers.isEmpty(), "The MUnit Mock Parsers haven't been defined");

        for (String elementName : parsers.keySet()) {
            registerBeanDefinitionParser(elementName, (BeanDefinitionParser) parsers.get(elementName));
        }
    }

}
