/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.construct.Flow;
import org.mule.munit.common.util.MunitMuleTestUtils;

public class MunitMuleEventBuilder {
    public static final String MUNIT_TEST_FLOW_CONSTRUCT_NAME = "appleFlow";
    public static final String ONE_WAY = "ONE_WAY";
    public static final String REQUEST_RESPONSE = "REQUEST_RESPONSE";

    public static MuleEvent buildGenericMuleEvent(MuleContext muleContext) {
        return MunitMuleEventBuilder.buildGenericMuleEvent(muleContext, REQUEST_RESPONSE);
    }

    public static MuleEvent buildGenericMuleEvent(MuleContext muleContext, String exchangePattern) {
        MessageExchangePattern messageExchangePattern = MunitMuleEventBuilder.getMessageExchangePattern(exchangePattern);
        try {
            Flow testFlow = (Flow)muleContext.getRegistry().lookupFlowConstruct(MUNIT_TEST_FLOW_CONSTRUCT_NAME);
            if (null == testFlow) {
                testFlow = MunitMuleTestUtils.getTestFlow(muleContext);
            }
            return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"", muleContext), messageExchangePattern, (FlowConstruct)testFlow);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static MuleEvent buildMuleEvent(MuleContext muleContext, FlowConstruct flowConstruct) {
        return MunitMuleEventBuilder.buildMuleEvent(muleContext, REQUEST_RESPONSE, flowConstruct);
    }

    public static MuleEvent buildMuleEvent(MuleContext muleContext, String exchangePattern, FlowConstruct flowConstruct) {
        MessageExchangePattern messageExchangePattern = MunitMuleEventBuilder.getMessageExchangePattern(exchangePattern);
        try {
            return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"", muleContext), messageExchangePattern, flowConstruct);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MessageExchangePattern getMessageExchangePattern(String exchangePattern) {
        MessageExchangePattern messageExchangePattern = MunitMuleEventBuilder.findMessageExchangePattern(exchangePattern);
        if (null == messageExchangePattern) {
            throw new IllegalArgumentException("The exchange pattern should be one of: ONE_WAY, REQUEST_RESPONSE");
        }
        return messageExchangePattern;
    }

    private static MessageExchangePattern findMessageExchangePattern(String exchangePattern) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)exchangePattern), (Object)"The exchange pattern must not be null nor empty.");
        if (ONE_WAY.equals(exchangePattern)) {
            return MessageExchangePattern.ONE_WAY;
        }
        if (REQUEST_RESPONSE.equals(exchangePattern)) {
            return MessageExchangePattern.REQUEST_RESPONSE;
        }
        return null;
    }
}

