/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.spring.config.document;

import java.util.LinkedHashMap;
import java.util.Stack;
import org.mule.config.spring.parsers.DefaultXmlMetadataAnnotations;
import org.mule.config.spring.parsers.XmlMetadataAnnotations;
import org.mule.munit.runner.spring.config.document.DomWalkerElement;
import org.mule.munit.runner.spring.config.document.MunitMetadaAnnotations;
import org.mule.util.SystemUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlMetadataAnnotator
extends DefaultHandler {
    private static final UserDataHandler NULL_DATA_HANDLER = new UserDataHandler(){

        @Override
        public void handle(short operation, String key, Object data, Node src, Node dst) {
        }
    };
    private Locator locator;
    private DomWalkerElement walker;
    private Stack<XmlMetadataAnnotations> annotationsStack = new Stack();

    public XmlMetadataAnnotator(Document doc) {
        this.walker = new DomWalkerElement(doc.getDocumentElement());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.walker = this.walker.walkIn();
        DefaultXmlMetadataAnnotations metadataBuilder = new DefaultXmlMetadataAnnotations();
        metadataBuilder.setLineNumber(this.locator.getLineNumber());
        LinkedHashMap<String, String> attsMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < atts.getLength(); ++i) {
            attsMap.put(atts.getQName(i), atts.getValue(i));
        }
        metadataBuilder.appendElementStart(qName, attsMap);
        this.annotationsStack.push((XmlMetadataAnnotations)metadataBuilder);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.annotationsStack.peek().appendElementBody(new String(ch, start, length).trim());
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        XmlMetadataAnnotations metadataAnnotations = this.annotationsStack.pop();
        metadataAnnotations.appendElementEnd(qName);
        if (!this.annotationsStack.isEmpty()) {
            this.annotationsStack.peek().appendElementBody(SystemUtils.LINE_SEPARATOR + metadataAnnotations.getElementString() + SystemUtils.LINE_SEPARATOR);
        }
        this.walker.getParentNode().setUserData("metadataAnnotations", metadataAnnotations, NULL_DATA_HANDLER);
        MunitMetadaAnnotations munitMetadaAnnotations = this.buildMuniMetadataAnnotation(metadataAnnotations.getLineNumber());
        this.walker.getParentNode().setUserData("munitmetadataAnnotations", munitMetadaAnnotations, new UserDataHandler(){

            @Override
            public void handle(short operation, String key, Object data, Node src, Node dst) {
                if (operation == 2) {
                    dst.setUserData(key, data, this);
                }
            }
        });
        this.walker = this.walker.walkOut();
    }

    private MunitMetadaAnnotations buildMuniMetadataAnnotation(Integer lineNumber) {
        MunitMetadaAnnotations munitMetadaAnnotations = new MunitMetadaAnnotations();
        munitMetadaAnnotations.putAnnotation("lineNumber", lineNumber);
        return munitMetadaAnnotations;
    }
}

