/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.assertion.utils;

import com.google.common.base.Preconditions;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.module.scripting.component.Scriptable;

public class ScriptableRunner {
    public Object run(String scriptName, MuleContext muleContext) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)scriptName), (Object)"The scriptName should not be null nor empty");
        Preconditions.checkNotNull((Object)muleContext, (Object)"The muleContext must not be null");
        Object registeredScript = muleContext.getRegistry().lookupObject(scriptName);
        Preconditions.checkNotNull((Object)registeredScript, (Object)("The script called " + scriptName + " could not be found"));
        if (registeredScript instanceof Scriptable) {
            Scriptable script = (Scriptable)registeredScript;
            Bindings bindings = script.getScriptEngine().createBindings();
            script.populateDefaultBindings(bindings);
            try {
                return script.runScript(bindings);
            }
            catch (ScriptException e) {
                throw new RuntimeException("Your script has an execution error ", e);
            }
        }
        throw new IllegalArgumentException("The scriptName provided does not belong to a Mule Script");
    }
}

