/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.api.spring.config.parsers.model;


import org.mule.config.spring.factories.MessageProcessorChainFactoryBean;

import java.util.HashMap;
import java.util.Map;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;
import static org.apache.commons.lang.StringUtils.isNotBlank;


public class NestedChildElement implements ParseableElement {

    private Class elementClass;

    private String elementName;
    private String elementPropertyName;
    private Map<String, String> attributePropertyMap;


    private NestedChildElement(Class elementClass) {
        checkNotNull(elementClass, "The element class must not be null.");
        this.elementClass = elementClass;
        this.attributePropertyMap = new HashMap<>();
    }

    public static class NestedChildElementBuilder {
        protected Class elementClass;
        protected String elementName;
        protected String elementPropertyName;

        protected Map<String, String> attributePropertyMap;

        public NestedChildElementBuilder() {
            this.elementClass = MessageProcessorChainFactoryBean.class;
            this.attributePropertyMap = new HashMap<>();
        }

        public NestedChildElementBuilder withElementName(String elementName) {
            checkArgument(isNotBlank(elementName), "The element name must not be null nor empty.");
            this.elementName = elementName;
            return this;
        }

        public NestedChildElementBuilder withElementPropertyName(String elementPropertyName) {
            checkArgument(isNotBlank(elementPropertyName), "The element property name must not be null nor empty.");
            this.elementPropertyName = elementPropertyName;
            return this;
        }

        public NestedChildElementBuilder withAttribute(String attributeName, String propertyName) {
            checkArgument(isNotBlank(attributeName), "The attribute name must not be null nor empty.");
            checkArgument(isNotBlank(propertyName), "The property name must not be null nor empty.");
            this.attributePropertyMap.put(attributeName, propertyName);
            return this;
        }

        public NestedChildElement build() {
            checkArgument(isNotBlank(elementName), "Build Fail. The element name must not be null.");
            checkArgument(isNotBlank(elementPropertyName), "Build Fail. The  element propertyName name must not be null.");

            NestedChildElement childElement = new NestedChildElement(elementClass);
            childElement.elementName = this.elementName;
            childElement.elementPropertyName = this.elementPropertyName;
            childElement.attributePropertyMap.putAll(this.attributePropertyMap);

            return childElement;
        }
    }

    public String getElementName() {
        return elementName;
    }

    public String getElementPropertyName() {
        return elementPropertyName;
    }

    public Class getElementClass() {
        return elementClass;
    }

    public Map<String, String> getAttributePropertyMap() {
        return attributePropertyMap;
    }
}


