/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.spring.config;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.xerces.parsers.DOMParser;
import org.mule.api.MuleContext;
import org.mule.config.ConfigResource;
import org.mule.config.spring.MissingParserProblemReporter;
import org.mule.config.spring.MuleArtifactContext;
import org.mule.munit.runner.spring.config.MunitApplicationContextPostProcessor;
import org.mule.munit.runner.spring.config.document.MunitAnnotatedDocumentLoader;
import org.mule.munit.runner.spring.config.reader.MunitBeanDefinitionDocumentReader;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.DocumentLoader;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;

public class MunitApplicationContext
extends MuleArtifactContext {
    private Map<String, BeanDefinition> beanDefinitionsToRegister = new HashMap<String, BeanDefinition>();
    private Class endpointFactoryClass;
    private DOMParser munitDomParser;
    private String munitFactoryPostProcessorId;

    public MunitApplicationContext(MuleContext muleContext, ConfigResource[] configResources, Class endpointFactoryClass, DOMParser munitDomParser, String munitFactoryPostProcessorId) throws BeansException {
        super(muleContext, configResources);
        Preconditions.checkNotNull((Object)endpointFactoryClass, (Object)"The endpoint Factory class must not be null.");
        this.endpointFactoryClass = endpointFactoryClass;
        Preconditions.checkNotNull((Object)munitDomParser, (Object)"The dom parsers must not be null.");
        this.munitDomParser = munitDomParser;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)munitFactoryPostProcessorId), (Object)"The munit factory post processor id must not be null nor empty.");
        this.munitFactoryPostProcessorId = munitFactoryPostProcessorId;
    }

    public void putBeanDefinitionToRegister(String beanId, BeanDefinition beanDefinition) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)beanId), (Object)"The bean ID must not be null nor empty.");
        Preconditions.checkNotNull((Object)beanDefinition, (Object)"The bean definition not be null.");
        this.beanDefinitionsToRegister.put(beanId, beanDefinition);
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        Preconditions.checkNotNull((Object)beanFactory, (Object)"The bean factory must not be null.");
        XmlBeanDefinitionReader beanDefinitionReader = this.getMunitXmlBeanDefinitionReader(beanFactory);
        beanDefinitionReader.setDocumentReaderClass(MunitBeanDefinitionDocumentReader.class);
        this.registerBeanDefinitions(beanFactory);
        beanDefinitionReader.setProblemReporter((ProblemReporter)new MissingParserProblemReporter());
        this.triggerBeanCreation(beanFactory);
        this.communicateMuleContextToParsers(beanDefinitionReader);
    }

    protected void triggerBeanCreation(DefaultListableBeanFactory beanFactory) {
        for (String beanId : this.beanDefinitionsToRegister.keySet()) {
            beanFactory.getBean(beanId);
        }
    }

    protected void registerBeanDefinitions(DefaultListableBeanFactory beanFactory) {
        for (String beanId : this.beanDefinitionsToRegister.keySet()) {
            BeanDefinition beanDefinition = this.beanDefinitionsToRegister.get(beanId);
            beanFactory.registerBeanDefinition(beanId, beanDefinition);
        }
    }

    protected XmlBeanDefinitionReader getMunitXmlBeanDefinitionReader(DefaultListableBeanFactory beanFactory) {
        XmlBeanDefinitionReader beanDefinitionReader = (XmlBeanDefinitionReader)this.createBeanDefinitionReader(beanFactory);
        beanDefinitionReader.setDocumentLoader((DocumentLoader)new MunitAnnotatedDocumentLoader(this.munitDomParser));
        return beanDefinitionReader;
    }

    protected void communicateMuleContextToParsers(XmlBeanDefinitionReader beanDefinitionReader) {
        MunitApplicationContext.getCurrentMuleContext().set(this.getMuleContext());
        beanDefinitionReader.loadBeanDefinitions(this.getConfigResources());
        MunitApplicationContext.getCurrentMuleContext().remove();
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(this.munitFactoryPostProcessorId);
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        MunitApplicationContextPostProcessor postProcessor = new MunitApplicationContextPostProcessor();
        String mockConnectorsPropName = "mockConnectors";
        String mockInboundsPropName = "mockInbounds";
        String mockingExcludedFlows = "mockingExcludedFlows";
        Preconditions.checkNotNull((Object)propertyValues.getPropertyValue(mockConnectorsPropName), (Object)("The property " + mockConnectorsPropName + " is not present in the bean " + this.munitFactoryPostProcessorId));
        Preconditions.checkNotNull((Object)propertyValues.getPropertyValue(mockInboundsPropName), (Object)("The property " + mockInboundsPropName + " is not present in the bean " + this.munitFactoryPostProcessorId));
        if (propertyValues.getPropertyValue(mockConnectorsPropName).getValue().getClass().isAssignableFrom(Boolean.class)) {
            postProcessor.setMockConnectors((Boolean)propertyValues.getPropertyValue(mockConnectorsPropName).getValue());
        } else {
            postProcessor.setMockConnectors(Boolean.valueOf((String)propertyValues.getPropertyValue(mockConnectorsPropName).getValue()));
        }
        if (propertyValues.getPropertyValue(mockInboundsPropName).getValue().getClass().isAssignableFrom(Boolean.class)) {
            postProcessor.setMockInbounds((Boolean)propertyValues.getPropertyValue(mockInboundsPropName).getValue());
        } else {
            postProcessor.setMockInbounds(Boolean.valueOf((String)propertyValues.getPropertyValue(mockInboundsPropName).getValue()));
        }
        if (null == propertyValues.getPropertyValue(mockingExcludedFlows)) {
            postProcessor.setMockingExcludedFlows(new ArrayList<String>());
        } else if (List.class.isAssignableFrom(propertyValues.getPropertyValue(mockingExcludedFlows).getValue().getClass())) {
            postProcessor.setMockingExcludedFlows((List)propertyValues.getPropertyValue(mockingExcludedFlows).getValue());
        } else {
            postProcessor.setMockingExcludedFlows(new ArrayList<String>());
        }
        postProcessor.postProcessBeanFactory(beanFactory, this.endpointFactoryClass);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        Map result = super.getBeansOfType(type, includeNonSingletons, allowEagerInit);
        if (result.isEmpty()) {
            String[] beanDefinitionNames;
            for (String beanDefinitionName : beanDefinitionNames = super.getBeanDefinitionNames()) {
                BeanDefinition beanDefinition = super.getBeanFactory().getBeanDefinition(beanDefinitionName);
                if (!"create".equals(beanDefinition.getFactoryMethodName()) || !"__messageProcessorEnhancerFactory".equals(beanDefinition.getFactoryBeanName())) continue;
                try {
                    Class<?> beanClass = Class.forName(beanDefinition.getBeanClassName());
                    if (!type.isAssignableFrom(beanClass)) continue;
                    result.put(beanDefinitionName, this.getBean(beanDefinitionName));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public Map<String, BeanDefinition> getBeanDefinitionsToRegister() {
        return this.beanDefinitionsToRegister;
    }

    public Class getEndpointFactoryClass() {
        return this.endpointFactoryClass;
    }

    public DOMParser getMunitDomParser() {
        return this.munitDomParser;
    }

    public String getMunitFactoryPostProcessorId() {
        return this.munitFactoryPostProcessorId;
    }
}

