/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.api.spring.config.parsers;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.parsers.generic.OrphanDefinitionParser;
import org.mule.config.spring.util.ProcessingStrategyUtils;
import org.mule.munit.api.spring.config.parsers.MunitDefinitionParser;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class MunitOrphanDefinitionParser
extends OrphanDefinitionParser
implements MunitDefinitionParser {
    private Class messageProcessorClass;
    private String scope;
    private Map<String, String> attributePropertyMap;

    private MunitOrphanDefinitionParser(Class messageProcessorClass, String scope, Map<String, String> attributePropertyMap) {
        super(messageProcessorClass, true);
        this.addIgnored("abstract");
        this.addIgnored("name");
        this.addIgnored("processingStrategy");
        this.messageProcessorClass = messageProcessorClass;
        this.scope = scope;
        this.attributePropertyMap = attributePropertyMap;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addConstructorArgValue((Object)element.getAttribute("name"));
        builder.addConstructorArgReference("_muleContext");
        this.parseMessageProcessorAttributes(element, builder);
        ProcessingStrategyUtils.configureProcessingStrategy((Element)element, (BeanDefinitionBuilder)builder, (String)ProcessingStrategyUtils.QUEUED_ASYNC_PROCESSING_STRATEGY);
        super.doParse(element, parserContext, builder);
    }

    protected void parseMessageProcessorAttributes(Element element, BeanDefinitionBuilder builder) {
        this.parseElementAttributes(this.attributePropertyMap, element, builder);
    }

    protected void parseElementAttributes(Map<String, String> attributePropetyMap, Element element, BeanDefinitionBuilder builder) {
        for (String attributeName : attributePropetyMap.keySet()) {
            String propertyName = attributePropetyMap.get(attributeName);
            if (!this.hasAttribute(element, attributeName)) continue;
            String attributeValue = element.getAttribute(attributeName);
            builder.addPropertyValue(propertyName, this.buildAttributeValue(attributeName, attributeValue));
        }
    }

    protected boolean hasAttribute(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        return value != null && !StringUtils.isBlank((String)value);
    }

    protected Object buildAttributeValue(String attributeName, String attributeValue) {
        if (attributeName.endsWith("-ref")) {
            if (attributeValue.startsWith("#[")) {
                return attributeValue;
            }
            return new RuntimeBeanReference(attributeValue);
        }
        return attributeValue;
    }

    public Class getMessageProcessorClass() {
        return this.messageProcessorClass;
    }

    public String getScope() {
        return this.scope;
    }

    public Map<String, String> getAttributePropertyMap() {
        return this.attributePropertyMap;
    }

    public static class MunitOrphanDefinitionParserBuilder {
        private Class messageProcessorClass;
        protected String scope;
        protected Map<String, String> attributePropertyMap = new HashMap<String, String>();

        public MunitOrphanDefinitionParserBuilder withMessageProcessorClass(Class messageProcessorClass) {
            Preconditions.checkNotNull((Object)messageProcessorClass, (Object)"The message processor class must not be null.");
            this.messageProcessorClass = messageProcessorClass;
            return this;
        }

        public MunitOrphanDefinitionParserBuilder withScope(String scope) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)scope), (Object)"The scope must not be null nor empty.");
            if (!scope.equals("prototype") && !scope.equals("singleton")) {
                throw new IllegalArgumentException("The provided scope is not valid.");
            }
            this.scope = scope;
            return this;
        }

        public MunitOrphanDefinitionParserBuilder withAttribute(String attributeName, String propertyName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)attributeName), (Object)"The attribute name must not be null nor empty.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)propertyName), (Object)"The property name must not be null nor empty.");
            this.attributePropertyMap.put(attributeName, propertyName);
            return this;
        }

        public MunitOrphanDefinitionParser build() {
            Preconditions.checkNotNull((Object)this.messageProcessorClass, (Object)"Build Fail. The message processor class can not be null.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.scope), (Object)"Build Fail.The scope can not be null nor empty.");
            MunitOrphanDefinitionParser parser = new MunitOrphanDefinitionParser(this.messageProcessorClass, this.scope, this.attributePropertyMap);
            return parser;
        }
    }
}

