/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.api.spring.config.parsers.model;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.factories.MessageProcessorChainFactoryBean;
import org.mule.munit.api.spring.config.parsers.model.ParseableElement;

public class NestedChildElement
implements ParseableElement {
    private Class elementClass;
    private String elementName;
    private String elementPropertyName;
    private Map<String, String> attributePropertyMap;

    private NestedChildElement(Class elementClass) {
        Preconditions.checkNotNull((Object)elementClass, (Object)"The element class must not be null.");
        this.elementClass = elementClass;
        this.attributePropertyMap = new HashMap<String, String>();
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public String getElementPropertyName() {
        return this.elementPropertyName;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public Map<String, String> getAttributePropertyMap() {
        return this.attributePropertyMap;
    }

    public static class NestedChildElementBuilder {
        protected Class elementClass = MessageProcessorChainFactoryBean.class;
        protected String elementName;
        protected String elementPropertyName;
        protected Map<String, String> attributePropertyMap = new HashMap<String, String>();

        public NestedChildElementBuilder withElementName(String elementName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)elementName), (Object)"The element name must not be null nor empty.");
            this.elementName = elementName;
            return this;
        }

        public NestedChildElementBuilder withElementPropertyName(String elementPropertyName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)elementPropertyName), (Object)"The element property name must not be null nor empty.");
            this.elementPropertyName = elementPropertyName;
            return this;
        }

        public NestedChildElementBuilder withAttribute(String attributeName, String propertyName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)attributeName), (Object)"The attribute name must not be null nor empty.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)propertyName), (Object)"The property name must not be null nor empty.");
            this.attributePropertyMap.put(attributeName, propertyName);
            return this;
        }

        public NestedChildElement build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.elementName), (Object)"Build Fail. The element name must not be null.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.elementPropertyName), (Object)"Build Fail. The  element propertyName name must not be null.");
            NestedChildElement childElement = new NestedChildElement(this.elementClass);
            childElement.elementName = this.elementName;
            childElement.elementPropertyName = this.elementPropertyName;
            childElement.attributePropertyMap.putAll(this.attributePropertyMap);
            return childElement;
        }
    }
}

