/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.spring.config.document;

import org.apache.commons.lang.Validate;

import java.util.HashMap;
import java.util.Map;

public class MunitMetadaAnnotations {
    public static final String LINE_NUMBER = "lineNumber";
    public static final String MUNIT_METADATA_ANNOTATIONS_KEY = "munitmetadataAnnotations";

    protected Map<String, Object> annotations = new HashMap<String, Object>();

    protected Map<String, Object> getActualAnnotations() {
        return this.annotations;
    }

    public Map<String, Object> getAnnotations() {
        Map<String, Object> currentAnnotations = new HashMap<>();
        currentAnnotations.putAll(annotations);
        return currentAnnotations;
    }

    public void putAnnotation(String key, Object value) {
        Validate.notEmpty(key, "The annotation key must not be null nor empty");
        annotations.put(key, value);
    }

    public Object getAnnotation(String key) {
        Validate.notEmpty(key, "The annotation key must not be null nor empty");
        return annotations.get(key);
    }

}