/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.spring.config.reader;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;

public class MunitBeanDefinitionScopper {
    private static List<Class> beanClasses = new ArrayList<Class>();

    public static synchronized void addBeanClass(Class beanClass) {
        Preconditions.checkNotNull((Object)beanClass, (Object)"The bean class must not be null");
        beanClasses.add(beanClass);
    }

    public static synchronized List<Class> getBeanClassList() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.addAll(beanClasses);
        return classes;
    }

    public static synchronized void clearBeanClassList() {
        beanClasses.clear();
    }

    public static void makeBeanDefinitionSingletonIfApplicable(BeanDefinition beanDefinition) throws ClassNotFoundException {
        Preconditions.checkNotNull((Object)beanDefinition, (Object)"The bean definition must not be null.");
        Class<?> beanType = Class.forName(beanDefinition.getBeanClassName());
        for (Class beanClass : beanClasses) {
            if (!beanClass.isAssignableFrom(beanType)) continue;
            beanDefinition.setScope("singleton");
        }
    }
}

