/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.spring.config.document;

import org.w3c.dom.Node;

public class DomWalkerElement {
    private final DomWalkerElement parent;
    private final Node node;

    private int childIndex = 0;

    public DomWalkerElement(Node node) {
        this.parent = null;
        this.node = node;
    }

    private DomWalkerElement(DomWalkerElement parent, Node node) {
        this.parent = parent;
        this.node = node;
    }

    public DomWalkerElement walkIn() {
        Node nextChild = node.getChildNodes().item(childIndex++);
        while (nextChild != null && nextChild.getNodeType() != Node.ELEMENT_NODE) {
            nextChild = node.getChildNodes().item(childIndex++);
        }
        return new DomWalkerElement(this, nextChild);
    }

    public DomWalkerElement walkOut() {
        Node nextSibling = parent.node.getNextSibling();
        while (nextSibling != null && nextSibling.getNodeType() != Node.ELEMENT_NODE) {
            nextSibling = nextSibling.getNextSibling();
        }
        return new DomWalkerElement(parent.parent, nextSibling);
    }

    public Node getParentNode() {
        return parent.node;
    }
} 