/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.api.spring.config.parsers.model;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.munit.api.spring.config.parsers.model.ParseableElement;

public class ChildElement
implements ParseableElement {
    private Class elementClass;
    private String elementName;
    private String elementPropertyName;
    private Map<String, String> attributePropertyMap = new HashMap<String, String>();
    private Map<String, ParseableElement> childElements = new HashMap<String, ParseableElement>();

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public String getElementPropertyName() {
        return this.elementPropertyName;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public Map<String, String> getAttributePropertyMap() {
        return this.attributePropertyMap;
    }

    public Map<String, ParseableElement> getChildElements() {
        return this.childElements;
    }

    public static class ChildElementBuilder {
        protected Class elementClass;
        protected String elementName;
        protected String elementPropertyName;
        protected Map<String, String> attributePropertyMap;
        protected HashMap<String, ParseableElement> childElements;

        public ChildElementBuilder(Class elementClass) {
            Preconditions.checkNotNull((Object)elementClass, (Object)"The element class must not be null.");
            this.elementClass = elementClass;
            this.attributePropertyMap = new HashMap<String, String>();
            this.childElements = new HashMap();
        }

        public ChildElementBuilder withElementName(String elementName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)elementName), (Object)"The element name must not be null nor empty.");
            this.elementName = elementName;
            return this;
        }

        public ChildElementBuilder withElementPropertyName(String elementPropertyName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)elementPropertyName), (Object)"The element property name must not be null nor empty.");
            this.elementPropertyName = elementPropertyName;
            return this;
        }

        public ChildElementBuilder withAttribute(String attributeName, String propertyName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)attributeName), (Object)"The attribute name must not be null nor empty.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)propertyName), (Object)"The property name must not be null nor empty.");
            this.attributePropertyMap.put(attributeName, propertyName);
            return this;
        }

        public ChildElementBuilder withChildElement(ParseableElement childElement) {
            Preconditions.checkNotNull((Object)childElement, (Object)"The child element must not be null.");
            this.childElements.put(childElement.getElementName(), childElement);
            return this;
        }

        public ChildElement build() {
            Preconditions.checkNotNull((Object)this.elementClass, (Object)"Build Fail. The element class must not be null.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.elementName), (Object)"Build Fail. The element name must not be null.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.elementPropertyName), (Object)"Build Fail. The  element propertyName name must not be null.");
            ChildElement childElement = new ChildElement();
            childElement.elementClass = this.elementClass;
            childElement.elementName = this.elementName;
            childElement.elementPropertyName = this.elementPropertyName;
            childElement.attributePropertyMap.putAll(this.attributePropertyMap);
            childElement.childElements.putAll(this.childElements);
            return childElement;
        }
    }
}

