/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.spring.config.document;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.apache.xerces.parsers.DOMParser;
import org.mule.munit.runner.spring.config.document.XmlMetadataAnnotator;
import org.springframework.beans.factory.xml.DefaultDocumentLoader;
import org.springframework.beans.factory.xml.DocumentLoader;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MunitAnnotatedDocumentLoader
implements DocumentLoader {
    private DOMParser munitDomParser;
    private DocumentLoader defaultLoader = new DefaultDocumentLoader();

    public MunitAnnotatedDocumentLoader(DOMParser munitDomParser) {
        Preconditions.checkNotNull((Object)munitDomParser, (Object)"The dom parsers must not be null.");
        this.munitDomParser = munitDomParser;
    }

    public Document loadDocument(InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler, int validationMode, boolean namespaceAware) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputSource.getByteStream(), (OutputStream)output);
        InputSource defaultInputSource = new InputSource(new ByteArrayInputStream(output.toByteArray()));
        InputSource enrichInputSource = new InputSource(new ByteArrayInputStream(output.toByteArray()));
        Document doc = this.defaultLoader.loadDocument(defaultInputSource, entityResolver, errorHandler, validationMode, namespaceAware);
        this.createSaxAnnotator(doc).parse(enrichInputSource);
        return doc;
    }

    protected XMLReader createSaxAnnotator(Document doc) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader documentReader = saxParser.getXMLReader();
        documentReader.setContentHandler(new XmlMetadataAnnotator(doc));
        return documentReader;
    }
}

