/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.api.spring.config.parsers.model;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.mule.munit.api.spring.config.parsers.model.ParseableElement;

public class MapChildElement
implements ParseableElement {
    private String elementName;
    private String elementPropertyName;
    private String itemName;

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public String getElementPropertyName() {
        return this.elementPropertyName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public static class MapChildElementBuilder {
        protected String elementName;
        protected String elementPropertyName;
        protected String itemName;

        public MapChildElementBuilder(String elementName, String elementPropertyName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)elementName), (Object)"The element name must not be null nor empty.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)elementPropertyName), (Object)"The element  property name must not be null nor empty.");
            this.elementName = elementName;
            this.elementPropertyName = elementPropertyName;
        }

        public MapChildElementBuilder withItemName(String itemName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)itemName), (Object)"The item name must not be null nor empty.");
            this.itemName = itemName;
            return this;
        }

        public MapChildElement build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.itemName), (Object)"Build Fail. The item name must not be null.");
            MapChildElement listChildElement = new MapChildElement();
            listChildElement.elementName = this.elementName;
            listChildElement.elementPropertyName = this.elementPropertyName;
            listChildElement.itemName = this.itemName;
            return listChildElement;
        }
    }
}

