/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.spring.config.reader;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mule.config.spring.ElementValidator;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.munit.runner.spring.config.reader.MunitHandlerWrapper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MunitBeanDefinitionParserDelegate
extends MuleHierarchicalBeanDefinitionParserDelegate {
    public static final String BEANS = "beans";
    private static final String DOCUMENT_BUILDER_FACTORY = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private DefaultBeanDefinitionDocumentReader spring;

    public MunitBeanDefinitionParserDelegate(XmlReaderContext readerContext, DefaultBeanDefinitionDocumentReader spring) {
        super(readerContext, spring, new ElementValidator[0]);
        this.spring = spring;
    }

    protected NamespaceHandler getMunitHandlerWrapper(NamespaceHandler handler) {
        return new MunitHandlerWrapper(handler);
    }

    public BeanDefinition parseCustomElement(Element element, BeanDefinition parent) {
        BeanDefinition finalChild;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parsing: " + SpringXMLUtils.elementToString((Element)element)));
        }
        if (SpringXMLUtils.isBeansNamespace((Element)element)) {
            return this.handleSpringElements(element, parent);
        }
        String namespaceUri = element.getNamespaceURI();
        NamespaceHandlerResolver namespaceHandlerResolver = this.getReaderContext().getNamespaceHandlerResolver();
        NamespaceHandler handler = namespaceHandlerResolver.resolve(namespaceUri);
        if (handler == null) {
            this.getReaderContext().error("Unable to locate NamespaceHandler for namespace [" + namespaceUri + "]", (Object)element);
            return null;
        }
        boolean noRecurse = false;
        boolean forceRecurse = false;
        do {
            ParserContext parserContext = new ParserContext(this.getReaderContext(), (BeanDefinitionParserDelegate)this, parent);
            finalChild = this.getMunitHandlerWrapper(handler).parse(element, parserContext);
            this.registerBean(element, finalChild);
            noRecurse = noRecurse || MunitBeanDefinitionParserDelegate.testFlag((BeanDefinition)finalChild, (String)"org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE");
            boolean bl = forceRecurse = forceRecurse || MunitBeanDefinitionParserDelegate.testFlag((BeanDefinition)finalChild, (String)"org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_FORCE_RECURSE");
        } while (null != finalChild && MunitBeanDefinitionParserDelegate.testFlag((BeanDefinition)finalChild, (String)"org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_REPEAT_PARSE"));
        boolean isRecurse = noRecurse ? false : (forceRecurse ? true : SpringXMLUtils.isMuleNamespace((Element)element));
        if (isRecurse) {
            NodeList list = element.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (!(list.item(i) instanceof Element)) continue;
                this.parseCustomElement((Element)list.item(i), finalChild);
            }
        }
        if (MunitBeanDefinitionParserDelegate.testFlag((BeanDefinition)finalChild, (String)"org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_POST_CHILDREN")) {
            ParserContext parserContext = new ParserContext(this.getReaderContext(), (BeanDefinitionParserDelegate)this, parent);
            finalChild = handler.parse(element, parserContext);
        }
        return finalChild;
    }

    protected BeanDefinition handleSpringElements(Element element, BeanDefinition parent) {
        if (SpringXMLUtils.isLocalName((Element)element, (String)BEANS)) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance(DOCUMENT_BUILDER_FACTORY, ((Object)((Object)this)).getClass().getClassLoader());
                Document doc = factory.newDocumentBuilder().newDocument();
                doc.appendChild(doc.importNode(element, true));
                this.spring.registerBeanDefinitions(doc, this.getReaderContext());
                return parent;
            }
            catch (ParserConfigurationException var5) {
                throw new RuntimeException(var5);
            }
        }
        if (SpringXMLUtils.isLocalName((Element)element, (String)"property")) {
            this.parsePropertyElement(element, parent);
            return parent;
        }
        if (SpringXMLUtils.isLocalName((Element)element, (String)"bean")) {
            BeanDefinitionHolder holder = this.parseBeanDefinitionElement(element, parent);
            this.registerBeanDefinitionHolder(holder);
            return holder.getBeanDefinition();
        }
        throw new IllegalStateException("Unexpected Spring element: " + SpringXMLUtils.elementToString((Element)element));
    }
}

