/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.wrapped;

import org.mule.DefaultMuleEvent;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.security.Credentials;
import org.mule.api.transport.ReplyToHandler;

import java.io.OutputStream;
import java.net.URI;

public class MunitDefaultMuleEvent extends DefaultMuleEvent {

    public MunitDefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session) {
        super(message, exchangePattern, flowConstruct, session);
    }

    public MunitDefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct) {
        super(message, exchangePattern, flowConstruct);
    }

    public MunitDefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, ReplyToHandler replyToHandler, FlowConstruct flowConstruct) {
        super(message, exchangePattern, replyToHandler, flowConstruct);
    }

    public MunitDefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, OutputStream outputStream) {
        super(message, exchangePattern, flowConstruct, session, outputStream);
    }

    public MunitDefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, int timeout, Credentials credentials, OutputStream outputStream) {
        super(message, exchangePattern, flowConstruct, session, timeout, credentials, outputStream);
    }

    public MunitDefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session) {
        super(message, messageSourceURI, exchangePattern, flowConstruct, session);
    }

    public MunitDefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, OutputStream outputStream) {
        super(message, messageSourceURI, exchangePattern, flowConstruct, session, outputStream);
    }

    public MunitDefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, int timeout, Credentials credentials, OutputStream outputStream, ReplyToHandler replyToHandler) {
        super(message, messageSourceURI, exchangePattern, flowConstruct, session, timeout, credentials, outputStream, replyToHandler);
    }

    public MunitDefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, int timeout, Credentials credentials, OutputStream outputStream) {
        super(message, messageSourceURI, exchangePattern, flowConstruct, session, timeout, credentials, outputStream);
    }

    public MunitDefaultMuleEvent(MuleMessage message, InboundEndpoint endpoint, FlowConstruct flowConstruct, MuleSession session) {
        super(message, endpoint, flowConstruct, session);
    }

    public MunitDefaultMuleEvent(MuleMessage message, InboundEndpoint endpoint, FlowConstruct flowConstruct) {
        super(message, endpoint, flowConstruct);
    }

    public MunitDefaultMuleEvent(MuleMessage message, InboundEndpoint endpoint, FlowConstruct flowConstruct, MuleSession session, ReplyToHandler replyToHandler, Object replyToDestination, OutputStream outputStream) {
        super(message, endpoint, flowConstruct, session, replyToHandler, replyToDestination, outputStream);
    }

    public MunitDefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent) {
        super(message, rewriteEvent);
    }

    public MunitDefaultMuleEvent(MuleEvent rewriteEvent, FlowConstruct flowConstruct) {
        super(rewriteEvent, flowConstruct);
    }

    public MunitDefaultMuleEvent(MuleEvent rewriteEvent, ReplyToHandler replyToHandler) {
        super(rewriteEvent, replyToHandler);
    }

    public MunitDefaultMuleEvent(MuleEvent rewriteEvent, FlowConstruct flowConstruct, ReplyToHandler replyToHandler, Object replyToDestination) {
        super(rewriteEvent, flowConstruct, replyToHandler, replyToDestination);
    }

    public MunitDefaultMuleEvent(MuleEvent rewriteEvent, FlowConstruct flowConstruct, ReplyToHandler replyToHandler, Object replyToDestination, boolean synchronous) {
        super(rewriteEvent, flowConstruct, replyToHandler, replyToDestination, synchronous);
    }

    public MunitDefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, boolean synchronus) {
        super(message, rewriteEvent, synchronus);
    }

    public MunitDefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, boolean synchronus, boolean shareFlowVars) {
        super(message, rewriteEvent, synchronus, shareFlowVars);
    }

    public MunitDefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, boolean synchronus, boolean shareFlowVars, MessageExchangePattern messageExchangePattern) {
        super(message, rewriteEvent, synchronus, shareFlowVars, messageExchangePattern);
    }

    public MunitDefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, MuleSession session) {
        super(message, rewriteEvent, session);
    }

    protected MunitDefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, FlowConstruct flowConstruct, MuleSession session, boolean synchronous) {
        super(message, rewriteEvent, flowConstruct, session, synchronous);
    }

    protected MunitDefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, boolean synchronous, boolean shareFlowVars, MessageExchangePattern messageExchangePattern, ReplyToHandler replyToHandler) {
        super(message, rewriteEvent, synchronous, shareFlowVars, messageExchangePattern, replyToHandler);
    }

    protected MunitDefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, FlowConstruct flowConstruct, MuleSession session, boolean synchronous, boolean shareFlowVars, MessageExchangePattern messageExchangePattern, ReplyToHandler replyToHandler) {
        super(message, rewriteEvent, flowConstruct, session, synchronous, shareFlowVars, messageExchangePattern, replyToHandler);
    }

    protected MunitDefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, FlowConstruct flowConstruct, MuleSession session, boolean synchronous, ReplyToHandler replyToHandler, Object replyToDestination, boolean shareFlowVars, MessageExchangePattern messageExchangePattern) {
        super(message, rewriteEvent, flowConstruct, session, synchronous, replyToHandler, replyToDestination, shareFlowVars, messageExchangePattern);
    }

    public MunitDefaultMuleEvent(MuleMessage message, URI messageSourceURI, String messageSourceName, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, int timeout, Credentials credentials, OutputStream outputStream, String encoding, boolean transacted, boolean synchronous, Object replyToDestination, ReplyToHandler replyToHandler) {
        super(message, messageSourceURI, messageSourceName, exchangePattern, flowConstruct, session, timeout, credentials, outputStream, encoding, transacted, synchronous, replyToDestination, replyToHandler);
    }
}
