/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.util;

import org.mule.api.MuleContext;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.construct.Flow;
import org.mule.session.DefaultMuleSession;

/**
 * Utilities for creating test and Mock Mule objects
 */
public final class MunitMuleTestUtils {
    public static final String APPLE_FLOW = "appleFlow";

    public static Flow getTestFlow(MuleContext context) throws Exception {
        return getTestFlow(APPLE_FLOW, context);
    }

    public static Flow getTestFlow(String name, MuleContext context) throws Exception {
        return getTestFlow(name, context, true);
    }

    public static Flow getTestFlow(String name, MuleContext context, boolean initialize)
            throws Exception {
        final Flow flow = new Flow(name, context);
        if (initialize) {
            context.getRegistry().registerFlowConstruct(flow);
        }

        return flow;
    }

    public static MuleSession getTestSession(MuleContext context) {
        return getTestSession(null, context);
    }

    public static MuleSession getTestSession(FlowConstruct flowConstruct, MuleContext context) {
        return new DefaultMuleSession();
    }


}
