/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.api.model;

import java.io.Serializable;


/**
 * <p>
 * A model that represents a property of a Message
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class Property extends DefaultTypedKeyValue {

  @Override
  public Serializable getValue() {
    return (Serializable) super.getValue();
  }

  @Override
  @SuppressWarnings("RedundantCast")
  public void setValue(Object value) {
    super.setValue((Serializable) value);
  }

  @Override
  public boolean equals(Object object) {
    return object instanceof Property && super.equals(object);
  }
}
