/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.api.event;

import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.internal.message.InternalMessage;

/**
 * <p>
 * This class provides a friendly API to build a {@link Message}
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MessageBuilderDecorator {

  private final InternalMessage.Builder builder;

  public MessageBuilderDecorator() {
    builder = (InternalMessage.Builder) InternalMessage.builder();
  }

  public MessageBuilderDecorator(Message originalMessage) {
    this.builder = InternalMessage.builder(originalMessage);
  }

  public MessageBuilderDecorator withPayload(Object payload) {
    builder.value(payload);
    return this;
  }

  public MessageBuilderDecorator withMediaType(MediaType mediaType) {
    builder.mediaType(mediaType);
    return this;
  }

  public MessageBuilderDecorator withAttributes(Object attributes) {
    builder.attributes(TypedValue.of(attributes));
    return this;
  }

  public MessageBuilderDecorator withAttributes(TypedValue attributes) {
    builder.attributes(attributes);
    return this;
  }

  public Message build() {
    return builder.build();
  }
}
