/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.api.util;

import org.mule.munit.common.util.ClassUtils;
import org.mule.munit.common.util.FileUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.message.ds.ByteArrayDataSource;
import org.mule.runtime.core.api.message.ds.InputStreamDataSource;
import org.mule.runtime.core.api.message.ds.StringDataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;


/**
 * <code>IOUtils</code> contains useful methods for dealing with I/O operations This is based on the mule core class so we can
 * have control over it
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class IOUtils extends org.apache.commons.io.IOUtils {

  private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);



  /**
   * Transforms an Object into a DataHandler of its corresponding type.
   *
   * @param name the name of the attachment being handled
   * @param object the attachment to be handled
   * @param contentType the Content-Type of the attachment that is being handled
   * @return a {@link DataHandler} of the corresponding attachment
   * @throws IOException if the transformation fails.
   */
  public static DataHandler toDataHandler(String name, Object object, MediaType contentType) throws IOException {
    DataHandler dh;
    if (object instanceof File) {
      if (contentType != null) {
        dh = new DataHandler(new FileInputStream((File) object), contentType.toString());
      } else {
        dh = new DataHandler(new FileDataSource((File) object));
      }
    } else if (object instanceof URL) {
      if (contentType != null) {
        dh = new DataHandler(((URL) object).openStream(), contentType.toString());
      } else {
        dh = new DataHandler((URL) object);
      }
    } else if (object instanceof String) {
      if (contentType != null) {
        dh = new DataHandler(new StringDataSource((String) object, name, contentType));
      } else {
        dh = new DataHandler(new StringDataSource((String) object, name));
      }
    } else if (object instanceof byte[] && contentType != null) {
      dh = new DataHandler(new ByteArrayDataSource((byte[]) object, contentType, name));
    } else if (object instanceof InputStream && contentType != null) {
      dh = new DataHandler(new InputStreamDataSource((InputStream) object, contentType, name));
    } else {
      dh = new DataHandler(object, contentType.toString());
    }
    return dh;
  }

}
