/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.api.model;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

import static org.apache.commons.lang3.Validate.notNull;

import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

import java.util.List;


/**
 * <p>
 * An abstract model that represents a Mule Event
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class Event {

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  @Placement(order = 1)
  private Payload payload = new Payload();

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  @Placement(order = 2)
  private EventAttributes attributes = new EventAttributes();

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  @Placement(order = 3)
  private EventError error = new EventError();

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  @Placement(order = 4)
  private List<Variable> variables;

  public void setVariables(List<Variable> variables) {
    notNull(variables, "Variables can not be null");
    this.variables = variables;
  }

  public Payload getPayload() {
    return payload;
  }

  public EventAttributes getAttributes() {
    return attributes;
  }

  public EventError getError() {
    return error;
  }

  public List<Variable> getVariables() {
    return variables;
  }

  public void setPayload(Payload payload) {
    this.payload = payload;
  }

  public void setAttributes(EventAttributes attributes) {
    this.attributes = attributes;
  }

  public void setError(EventError error) {
    this.error = error;
  }
}
