/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.api.model;

import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

import static org.mule.runtime.api.meta.ExpressionSupport.REQUIRED;

/**
 * This class exits to decouple the SDK model and the plain old model we use without SDK
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class UntypedEventError extends BaseEventError {

  private static class CustomEventError extends EventError {

    private final Object objectCause;

    public CustomEventError(String id, Object objectCause) {
      this.objectCause = objectCause;
      this.setTypeId(id);
    }

    @Override
    public Object getCause() {
      return objectCause == null ? super.getCause() : objectCause;
    }
  }

  @Parameter
  @Optional
  @Example("ANY")
  @Placement(order = 0)
  private String id;

  @Parameter
  @Optional
  @Placement(order = 1)
  @Expression(REQUIRED)
  private Object exception;

  @Override
  public String getTypeId() {
    return id;
  }

  @Override
  public Object getCause() {
    return exception;
  }

  @Override
  public void setTypeId(String id) {
    this.id = id;
  }

  @Override
  public void setCause(Object cause) {
    this.exception = cause;
  }

  public EventError toEventError() {
    return new CustomEventError(id, exception);
  }
}
