/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.processor.interceptor;

import net.sf.cglib.proxy.MethodProxy;
import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.modules.interceptor.processors.AbstractMessageProcessorInterceptor;
import org.mule.modules.interceptor.processors.MessageProcessorBehavior;
import org.mule.munit.common.MunitUtils;
import org.mule.munit.common.processor.MockedMessageProcessorManager;
import org.mule.munit.common.processor.MunitMessageProcessorCall;
import org.mule.munit.common.processor.SpyAssertion;
import org.mule.munit.common.processors.InterceptingMessageProcessorHandler;

public class MunitMessageProcessorInterceptor
extends AbstractMessageProcessorInterceptor {
    private String fileName;
    private String lineNumber;

    public Object process(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        MuleEvent originalEvent = (MuleEvent)args[0];
        EventCopyManager eventCopyManager = new EventCopyManager(originalEvent);
        MuleEvent copyEvent = eventCopyManager.getCopyEvent();
        MockedMessageProcessorManager manager = this.getMockedMessageProcessorManager(copyEvent.getMuleContext());
        MunitMessageProcessorCall messageProcessorCall = this.buildCall(copyEvent);
        this.runSpyAssertion(manager.getBetterMatchingBeforeSpyAssertion(messageProcessorCall), copyEvent);
        this.registerCall(manager, messageProcessorCall);
        MessageProcessorBehavior behavior = manager.getBetterMatchingBehavior(messageProcessorCall);
        if (behavior != null) {
            if (behavior.getExceptionToThrow() != null) {
                this.runSpyAssertion(manager.getBetterMatchingAfterSpyAssertion(messageProcessorCall), copyEvent);
                throw behavior.getExceptionToThrow();
            }
            if (behavior.getMuleMessageTransformer() != null) {
                copyEvent.setMessage(behavior.getMuleMessageTransformer().transform(copyEvent.getMessage()));
            }
            this.runSpyAssertion(manager.getBetterMatchingAfterSpyAssertion(messageProcessorCall), copyEvent);
            return this.handleInterceptingMessageProcessors(obj, copyEvent);
        }
        eventCopyManager.rollBackRequestContext();
        Object o = this.invokeSuper(obj, args, proxy);
        this.runSpyAssertion(manager.getBetterMatchingAfterSpyAssertion(messageProcessorCall), (MuleEvent)o);
        return o;
    }

    protected Object handleInterceptingMessageProcessors(Object obj, MuleEvent event) throws Throwable {
        return new InterceptingMessageProcessorHandler(obj).invokeProcessNext(event);
    }

    protected Object invokeSuper(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        return proxy.invokeSuper(obj, args);
    }

    private void registerCall(MockedMessageProcessorManager manager, MunitMessageProcessorCall messageProcessorCall) {
        manager.addCall(messageProcessorCall);
    }

    private void runSpyAssertion(SpyAssertion spyAssertion, MuleEvent event) {
        if (spyAssertion == null) {
            return;
        }
        MunitUtils.verifyAssertions(event, spyAssertion.getMessageProcessors());
    }

    private MunitMessageProcessorCall buildCall(MuleEvent event) {
        MunitMessageProcessorCall call = new MunitMessageProcessorCall(this.id);
        call.setAttributes(this.getAttributes(event));
        call.setFlowConstruct(event.getFlowConstruct());
        call.setFileName(this.fileName);
        call.setLineNumber(this.lineNumber);
        return call;
    }

    protected MockedMessageProcessorManager getMockedMessageProcessorManager(MuleContext muleContext) {
        return (MockedMessageProcessorManager)((Object)muleContext.getRegistry().lookupObject(MockedMessageProcessorManager.ID));
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }

    public static class EventCopyManager {
        private MuleEvent originalEvent = null;
        private MuleEvent copyEvent = null;

        public EventCopyManager(MuleEvent originalEvent) {
            this.originalEvent = originalEvent;
        }

        public MuleEvent getCopyEvent() {
            if (null == this.copyEvent) {
                this.copyEvent = DefaultMuleEvent.copy((MuleEvent)this.originalEvent);
                RequestContext.setEvent((MuleEvent)this.copyEvent);
            }
            return this.copyEvent;
        }

        public void rollBackRequestContext() {
            RequestContext.setEvent((MuleEvent)this.originalEvent);
        }
    }
}

