/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common;


import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.execution.MessageProcessorExecutionTemplate;
import org.mule.munit.common.adapters.MuleMessageDataTypeSetterAdapter;

import java.util.List;
import java.util.Set;

import static org.mule.api.transport.PropertyScope.*;
import static org.mule.munit.common.mocking.NotDefinedPayload.isNotDefined;

/**
 * <p>Common class for common stuffs in Munit</p>
 * <p/>
 * <p>Do not use this class for everything</p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class MunitUtils {

    /**
     * <p>Copy one message to another</p>
     *
     * @param original      <p>The origin message</p>
     * @param copyToMessage <p>The result message</p>
     */
    public static void copyMessage(MuleMessage original, MuleMessage copyToMessage) {

        Object payload = original.getPayload();
        if (payload != null && !isNotDefined(payload)) {
            new MuleMessageDataTypeSetterAdapter(copyToMessage).setPayload(payload, original.getDataType());
        }

        if (containsProperties(original.getPropertyNames(INBOUND))) {
            for (String property : original.getPropertyNames(INBOUND)) {
                copyToMessage.setProperty(property, original.getInboundProperty(property), INBOUND);
            }
        }

        if (containsProperties(original.getPropertyNames(SESSION))) {
            for (String property : original.getPropertyNames(SESSION)) {
                copyToMessage.setProperty(property, original.getProperty(property, SESSION), SESSION);
            }
        }

        if (containsProperties(original.getPropertyNames(INVOCATION))) {
            for (String property : original.getPropertyNames(INVOCATION)) {
                copyToMessage.setProperty(property, original.getProperty(property, INVOCATION), INVOCATION);
            }
        }

        if (containsProperties(original.getPropertyNames(OUTBOUND))) {
            for (String property : original.getPropertyNames(OUTBOUND)) {
                copyToMessage.setProperty(property, original.getProperty(property, OUTBOUND), OUTBOUND);
            }
        }

    }

    private static boolean containsProperties(Set<String> propertyNames) {
        return propertyNames != null && !propertyNames.isEmpty();
    }

    public static void verifyAssertions(MuleEvent event, List<MessageProcessor> assertions) {
        if (assertions == null) {
            return;
        }

        for (MessageProcessor processor : assertions) {
            try {
                MessageProcessorExecutionTemplate.createExecutionTemplate().execute(processor, event);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }


}
