/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common;

import java.util.List;
import java.util.Set;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.execution.MessageProcessorExecutionTemplate;
import org.mule.munit.common.adapters.MuleMessageDataTypeSetterAdapter;
import org.mule.munit.common.mocking.NotDefinedPayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitUtils {
    public static void copyMessage(MuleMessage original, MuleMessage copyToMessage) {
        Object payload = original.getPayload();
        if (payload != null && !NotDefinedPayload.isNotDefined(payload)) {
            new MuleMessageDataTypeSetterAdapter(copyToMessage).setPayload(payload, original.getDataType());
        }
        if (MunitUtils.containsProperties(original.getPropertyNames(PropertyScope.INBOUND))) {
            for (String property : original.getPropertyNames(PropertyScope.INBOUND)) {
                copyToMessage.setProperty(property, original.getInboundProperty(property), PropertyScope.INBOUND);
            }
        }
        if (MunitUtils.containsProperties(original.getPropertyNames(PropertyScope.SESSION))) {
            for (String property : original.getPropertyNames(PropertyScope.SESSION)) {
                copyToMessage.setProperty(property, original.getProperty(property, PropertyScope.SESSION), PropertyScope.SESSION);
            }
        }
        if (MunitUtils.containsProperties(original.getPropertyNames(PropertyScope.INVOCATION))) {
            for (String property : original.getPropertyNames(PropertyScope.INVOCATION)) {
                copyToMessage.setProperty(property, original.getProperty(property, PropertyScope.INVOCATION), PropertyScope.INVOCATION);
            }
        }
        if (MunitUtils.containsProperties(original.getPropertyNames(PropertyScope.OUTBOUND))) {
            for (String property : original.getPropertyNames(PropertyScope.OUTBOUND)) {
                copyToMessage.setProperty(property, original.getProperty(property, PropertyScope.OUTBOUND), PropertyScope.OUTBOUND);
            }
        }
    }

    private static boolean containsProperties(Set<String> propertyNames) {
        return propertyNames != null && !propertyNames.isEmpty();
    }

    public static void verifyAssertions(MuleEvent event, List<MessageProcessor> assertions) {
        if (assertions == null) {
            return;
        }
        for (MessageProcessor processor : assertions) {
            try {
                MessageProcessorExecutionTemplate.createExecutionTemplate().execute(processor, event);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

