/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mocking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.modules.interceptor.processors.MessageProcessorCall;
import org.mule.modules.interceptor.processors.MessageProcessorId;
import org.mule.munit.common.mocking.Attribute;
import org.mule.munit.common.mocking.MunitMockingTool;
import org.mule.munit.common.mocking.SpyProcess;
import org.mule.munit.common.processor.SpyAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitSpy
extends MunitMockingTool {
    public MunitSpy(MuleContext muleContext) {
        super(muleContext);
    }

    public MunitSpy spyMessageProcessor(String name) {
        this.messageProcessorName = name;
        return this;
    }

    public MunitSpy ofNamespace(String namespace) {
        this.messageProcessorNamespace = namespace;
        return this;
    }

    public MunitSpy withAttributes(Map<String, Object> attributes) {
        if (attributes != null) {
            this.messageProcessorAttributes = attributes;
        }
        return this;
    }

    public MunitSpy withAttributes(Attribute ... attributes) {
        HashMap<String, Object> mapOfAttributes = new HashMap<String, Object>();
        for (Attribute attribute : attributes) {
            mapOfAttributes.put(attribute.getId(), attribute.getValue());
        }
        this.messageProcessorAttributes = mapOfAttributes;
        return this;
    }

    public MunitSpy before(List<SpyProcess> withSpies) {
        if (withSpies != null && !withSpies.isEmpty()) {
            MessageProcessorCall messageProcessorCall = this.createMessageProcessorCall();
            this.getManager().addBeforeCallSpyAssertion(this.createSpyAssertion(messageProcessorCall, withSpies));
        }
        return this;
    }

    private MessageProcessorCall createMessageProcessorCall() {
        MessageProcessorCall messageProcessorCall = new MessageProcessorCall(new MessageProcessorId(this.messageProcessorName, this.messageProcessorNamespace));
        messageProcessorCall.setAttributes(this.messageProcessorAttributes);
        return messageProcessorCall;
    }

    public MunitSpy before(SpyProcess ... withSpy) {
        return this.before(Arrays.asList(withSpy));
    }

    public MunitSpy after(List<SpyProcess> withSpies) {
        if (withSpies != null && !withSpies.isEmpty()) {
            MessageProcessorCall messageProcessorCall = this.createMessageProcessorCall();
            this.getManager().addAfterCallSpyAssertion(this.createSpyAssertion(messageProcessorCall, withSpies));
        }
        return this;
    }

    public MunitSpy after(SpyProcess ... withSpy) {
        return this.after(Arrays.asList(withSpy));
    }

    protected SpyAssertion createSpyAssertion(MessageProcessorCall call, List<SpyProcess> spyProcesses) {
        return new SpyAssertion(call, this.createMessageProcessors(spyProcesses));
    }

    private ArrayList<MessageProcessor> createMessageProcessors(List<SpyProcess> beforeCall) {
        ArrayList<MessageProcessor> beforeMessageProcessors = new ArrayList<MessageProcessor>();
        beforeMessageProcessors.add(this.createMessageProcessorFromSpy(beforeCall));
        return beforeMessageProcessors;
    }

    private MessageProcessor createMessageProcessorFromSpy(final List<SpyProcess> beforeCall) {
        return new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                if (beforeCall != null) {
                    for (SpyProcess process : beforeCall) {
                        process.spy(event);
                    }
                }
                return event;
            }
        };
    }
}

