/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.adapters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.munit.common.exception.MunitError;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MuleMessageDataTypeSetterAdapter {
    private static final String SET_PAYLOAD_METHOD = "setPayload";
    private static final String SET_PROPERTY_METHOD = "setProperty";

    private transient Log logger = LogFactory.getLog(this.getClass());

    private MuleMessage muleMessage;

    public MuleMessageDataTypeSetterAdapter(MuleMessage defaultMuleMessage) {
        this.muleMessage = defaultMuleMessage;
    }

    public void setPayload(Object payload, DataType dataType) {
        try {
            Method method = muleMessage.getClass().getMethod(SET_PAYLOAD_METHOD, Object.class, DataType.class);
            method.invoke(muleMessage, payload, dataType);
        } catch (NoSuchMethodException e) {
            muleMessage.setPayload(payload);
        } catch (InvocationTargetException e) {
            throw new MunitError("Fail to invoke setPayload method from " + this.getClass().getSimpleName(), e);
        } catch (IllegalAccessException e) {
            throw new MunitError("Fail to invoke setPayload method from " + this.getClass().getSimpleName(), e);
        }
    }

    public void setProperty(String key, Object value, PropertyScope scope, DataType dataType) {
        try {
            Method method = muleMessage.getClass().getMethod(SET_PROPERTY_METHOD, String.class, Object.class, PropertyScope.class, DataType.class);
            method.invoke(muleMessage, key, value, scope, dataType);
        } catch (NoSuchMethodException e) {
            muleMessage.setProperty(key, value, scope);
        } catch (InvocationTargetException e) {
            throw new MunitError("Fail to invoke setProperty method from " + this.getClass().getSimpleName(), e);
        } catch (IllegalAccessException e) {
            throw new MunitError("Fail to invoke setProperty method from " + this.getClass().getSimpleName(), e);
        }
    }
}
