/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.mocking;

import org.mule.api.MuleMessage;
import org.mule.modules.interceptor.processors.MuleMessageTransformer;
import org.mule.munit.common.MunitUtils;

/**
 * <p>
 * {@link MuleMessageTransformer} that copies one message into the other
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.4
 */
public class CopyMessageTransformer implements MuleMessageTransformer {

    private MuleMessage returnMessage;

    public CopyMessageTransformer(MuleMessage returnMessage) {
        this.returnMessage = returnMessage;
    }

    @Override
    public MuleMessage transform(MuleMessage original) {
        MunitUtils.copyMessage(returnMessage, original);
        return original;
    }
}
