/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.registry;

import net.sf.cglib.proxy.Enhancer;
import org.mule.api.registry.ResolverException;
import org.mule.api.transformer.Transformer;
import org.mule.registry.TypeBasedTransformerResolver;

import java.util.ArrayList;
import java.util.List;


/**
 * Transformer resolver that takes into consideration MUnit enhanced classes.
 */
public class MUnitTypeBasedTransformerResolver extends TypeBasedTransformerResolver {

    @Override
    protected Transformer getNearestTransformerMatch(List<Transformer> transformers, Class input, Class output)
        throws ResolverException {
        List<Transformer> enhancedTransformers = new ArrayList<Transformer>();
        for (Transformer transformer : transformers) {
            if (Enhancer.isEnhanced(transformer.getClass())) {
                enhancedTransformers.add(transformer);
            }
        }
        return super.getNearestTransformerMatch(enhancedTransformers, input, output);
    }
}
