/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.processor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.modules.interceptor.processors.MessageProcessorCall;
import org.mule.modules.interceptor.processors.MessageProcessorId;
import org.mule.modules.interceptor.processors.MessageProcessorManager;
import org.mule.munit.common.processor.MunitMessageProcessorCall;
import org.mule.munit.common.processor.SpyAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockedMessageProcessorManager
extends MessageProcessorManager {
    public static String ID = "_muleMockMpManager";
    private transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected List<MunitMessageProcessorCall> calls = new CopyOnWriteArrayList<MunitMessageProcessorCall>();
    protected List<SpyAssertion> beforeCallSpyAssertions = new CopyOnWriteArrayList<SpyAssertion>();
    protected List<SpyAssertion> afterCallSpyAssertions = new CopyOnWriteArrayList<SpyAssertion>();

    public void reset() {
        this.behaviors.clear();
        this.calls.clear();
        this.beforeCallSpyAssertions.clear();
        this.afterCallSpyAssertions.clear();
    }

    public List<MessageProcessorCall> findCallsFor(MessageProcessorId mpId, Map<String, Object> attributesMatchers) {
        this.logger.debug((Object)("Finding calls for message processor: " + mpId.getFullName()));
        ArrayList<MessageProcessorCall> expected = new ArrayList<MessageProcessorCall>();
        MessageProcessorCall matchingCall = new MessageProcessorCall(mpId);
        matchingCall.setAttributes(attributesMatchers);
        for (MessageProcessorCall messageProcessorCall : this.calls) {
            if (matchingCall.matchingWeight(messageProcessorCall) < 0) continue;
            expected.add(messageProcessorCall);
        }
        return expected;
    }

    public SpyAssertion getBetterMatchingBeforeSpyAssertion(MessageProcessorCall messageProcessorCall) {
        this.logger.debug((Object)("Finding Spy Before for: " + messageProcessorCall.getMessageProcessorId().getFullName()));
        return (SpyAssertion)this.getBetterMatchingAction(messageProcessorCall, this.beforeCallSpyAssertions);
    }

    public SpyAssertion getBetterMatchingAfterSpyAssertion(MessageProcessorCall messageProcessorCall) {
        this.logger.debug((Object)("Finding Spy After for: " + messageProcessorCall.getMessageProcessorId().getFullName()));
        return (SpyAssertion)this.getBetterMatchingAction(messageProcessorCall, this.afterCallSpyAssertions);
    }

    public synchronized void addCall(MunitMessageProcessorCall call) {
        this.calls.add(call);
    }

    public synchronized void addBeforeCallSpyAssertion(SpyAssertion spyAssertion) {
        this.beforeCallSpyAssertions.add(spyAssertion);
    }

    public synchronized void addAfterCallSpyAssertion(SpyAssertion spyAssertion) {
        this.afterCallSpyAssertions.add(spyAssertion);
    }

    public List<MunitMessageProcessorCall> getCalls() {
        return new LinkedList<MunitMessageProcessorCall>(this.calls);
    }
}

