/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.processor.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageProcessorAttributeFilter {
    private static transient Log logger = LogFactory.getLog(MessageProcessorAttributeFilter.class);
    private static Map<String, List<String>> classAttributeMap;

    public static Map<String, String> filterAttributes(Object messageProcessor, Map<String, String> attributes) {
        MessageProcessorAttributeFilter.initIfNecessary();
        HashMap<String, String> filteredAttribtues = new HashMap<String, String>();
        filteredAttribtues.putAll(attributes);
        for (String className : classAttributeMap.keySet()) {
            try {
                Class<?> clazz = Class.forName(className);
                if (!clazz.isAssignableFrom(messageProcessor.getClass())) continue;
                for (String a : classAttributeMap.get(className)) {
                    if (!filteredAttribtues.containsKey(a)) continue;
                    filteredAttribtues.remove(a);
                }
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)("Filter unwanted attributes from mp failed. No class could be found for name: " + className));
            }
        }
        return filteredAttribtues;
    }

    private static void initIfNecessary() {
        if (classAttributeMap == null) {
            classAttributeMap = new HashMap<String, List<String>>();
            MessageProcessorAttributeFilter.addForEachAttributes();
        }
    }

    private static void addForEachAttributes() {
        String className = "org.mule.routing.Foreach";
        ArrayList<String> attributesToFilter = new ArrayList<String>();
        attributesToFilter.add("name");
        classAttributeMap.put(className, attributesToFilter);
    }
}

