/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.mocking;

import org.mule.api.MuleMessage;
import org.mule.modules.interceptor.processors.MuleMessageTransformer;
import org.mule.transformer.AbstractMessageTransformer;

// warning: org.mule.transformer.AbstractMessageTransformer class should not to brake backward compatibility
/**
 * <p>
 * {@link org.mule.modules.interceptor.processors.MuleMessageTransformer} executes a {@link org.mule.transformer.AbstractMessageTransformer}
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.4
 */
public class MunitMuleMessageTransformer implements MuleMessageTransformer {
    private AbstractMessageTransformer muleTransformer;

    public MunitMuleMessageTransformer(AbstractMessageTransformer muleTransformer) {
        this.muleTransformer = muleTransformer;
    }

    @Override
    public MuleMessage transform(MuleMessage original) {
        try {
            return (MuleMessage) muleTransformer.transformMessage(original, "utf-8");
        } catch (Throwable e) {
            return original;
        }
    }
}
