/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common;

import java.util.List;
import java.util.Set;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.execution.MessageProcessorExecutionTemplate;
import org.mule.munit.common.adapters.MuleMessageDataTypeSetterAdapter;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.mocking.NotDefinedPayload;
import org.mule.munit.common.mocking.spy.SpyMessageProcessorContainer;
import org.mule.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitUtils {
    public static void copyMessage(MuleMessage original, MuleMessage copyToMessage) {
        Object payload = original.getPayload();
        if (payload != null && !NotDefinedPayload.isNotDefined(payload)) {
            new MuleMessageDataTypeSetterAdapter(copyToMessage).setPayload(payload, original.getDataType());
        }
        for (PropertyScope scope : new PropertyScope[]{PropertyScope.INBOUND, PropertyScope.OUTBOUND, PropertyScope.INVOCATION, PropertyScope.SESSION}) {
            if (!MunitUtils.containsProperties(original.getPropertyNames(scope))) continue;
            for (String key : original.getPropertyNames(scope)) {
                Object value = original.getProperty(key, scope);
                DataType type = original.getPropertyDataType(key, scope);
                new MuleMessageDataTypeSetterAdapter(copyToMessage).setProperty(key, value, scope, type);
            }
        }
    }

    private static boolean containsProperties(Set<String> propertyNames) {
        return propertyNames != null && !propertyNames.isEmpty();
    }

    public static void verifyAssertions(MuleEvent event, List<MessageProcessor> assertions) {
        if (assertions == null || assertions.isEmpty()) {
            return;
        }
        if (VoidMuleEvent.class.isAssignableFrom(event.getClass()) && SpyMessageProcessorContainer.class.isAssignableFrom(assertions.get(0).getClass())) {
            SpyMessageProcessorContainer spyProcesss = (SpyMessageProcessorContainer)assertions.get(0);
            if (spyProcesss.containsMessageProcessors().booleanValue()) {
                throw new MunitError("A Spy can not run over a VoidMuleEvent. Either remove the Spy's message processors or the Spy itself.");
            }
            return;
        }
        for (MessageProcessor processor : assertions) {
            try {
                MessageProcessorExecutionTemplate.createExecutionTemplate().execute(processor, event);
            }
            catch (Exception e) {
                MunitUtils.throwRootCauseIfMatches(e);
                throw new RuntimeException(e);
            }
        }
    }

    public static void throwRootCauseIfMatches(Exception e) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        if (null != rootCause) {
            if (AssertionError.class.isAssignableFrom(rootCause.getClass())) {
                throw (Error)ExceptionUtils.getRootCause((Throwable)e);
            }
            if (MunitError.class.isAssignableFrom(rootCause.getClass())) {
                throw (Error)ExceptionUtils.getRootCause((Throwable)e);
            }
        }
    }
}

