/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.processor.interceptor;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.processor.MessageProcessor;
import org.mule.munit.common.processor.MunitNamingPolicy;
import org.mule.munit.common.processor.interceptor.AbstractMunitMessageProcessorInterceptor;
import org.mule.munit.common.processor.interceptor.WrapperMunitMessageProcessorInterceptor;
import org.objenesis.ObjenesisStd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageProcessorFactoryBeanInterceptor
extends AbstractMunitMessageProcessorInterceptor {
    private ObjenesisStd objenesis = new ObjenesisStd();
    private transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object o = proxy.invokeSuper(obj, args);
        try {
            if (MessageProcessor.class.isAssignableFrom(o.getClass()) && !Enhancer.isEnhanced(o.getClass())) {
                WrapperMunitMessageProcessorInterceptor callback = new WrapperMunitMessageProcessorInterceptor((MessageProcessor)o);
                callback.setId(this.id);
                callback.setAttributes(this.attributes);
                callback.setFileName(this.fileName);
                callback.setLineNumber(this.lineNumber);
                Enhancer e = new Enhancer();
                e.setSuperclass(o.getClass());
                e.setInterceptDuringConstruction(true);
                e.setUseCache(false);
                e.setAttemptLoad(true);
                e.setNamingPolicy((NamingPolicy)new MunitNamingPolicy());
                e.setCallbackTypes(new Class[]{WrapperMunitMessageProcessorInterceptor.class});
                return this.createProxy(e.createClass(), (Callback)callback);
            }
            return o;
        }
        catch (Throwable e) {
            return o;
        }
    }

    protected Object process(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        return null;
    }

    private Object createProxy(Class<?> proxyClass, Callback interceptor) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object proxy = this.objenesis.newInstance(proxyClass);
        proxy.getClass().getDeclaredMethod("setCallbacks", new Callback[0].getClass()).invoke(proxy, new Object[]{new Callback[]{interceptor}});
        this.setAnnotationsIfNotPresent(proxy, "org.mule.AbstractAnnotatedObject", "annotations");
        this.setAnnotationsIfNotPresent(proxy, "org.mule.processor.AbstractMessageProcessorOwner", "annotations");
        return proxy;
    }

    protected void setAnnotationsIfNotPresent(Object obj, String annotatedClass, String annotatedField) {
        try {
            Field annotationsField;
            Class annotatedObjectClass = ClassUtils.getClass((String)annotatedClass);
            if (annotatedObjectClass != null && annotatedObjectClass.isInstance(obj) && (annotationsField = FieldUtils.getField(obj.getClass(), (String)annotatedField, (boolean)true)) != null && annotationsField.get(obj) == null) {
                FieldUtils.writeField((Field)annotationsField, (Object)obj, (Object)Collections.EMPTY_MAP, (boolean)true);
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.debug((Object)"Unable to instantiate annotations", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.debug((Object)"Unable to instantiate annotations", (Throwable)e);
        }
    }
}

