/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.processor.interceptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.NoOp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.modules.interceptor.processors.MessageProcessorId;
import org.mule.munit.common.processor.MunitNamingPolicy;
import org.mule.munit.common.processor.interceptor.MessageProcessorFactoryBeanInterceptor;
import org.mule.munit.common.processor.interceptor.MunitMessageProcessorInterceptor;
import org.mule.munit.runner.interceptor.AbstractMessageProcessorInterceptorFactory;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitMessageProcessorInterceptorFactory
extends AbstractMessageProcessorInterceptorFactory {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static Callback NULL_METHOD_INTERCEPTOR = new NoOp(){};
    private static CallbackFilter FACTORY_BEAN_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            if ("getObject".equals(method.getName())) {
                return 0;
            }
            return 1;
        }
    };
    private static CallbackFilter MESSAGE_PROCESSOR_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            Class<?> declaringClass = method.getDeclaringClass();
            if ((MessageProcessor.class.isAssignableFrom(declaringClass) || DevkitBasedMessageProcessor.class.isAssignableFrom(declaringClass)) && method.getName().equals("process") && method.getParameterTypes().length == 1 && MuleEvent.class.isAssignableFrom(method.getParameterTypes()[0])) {
                return 0;
            }
            return 1;
        }
    };

    private Object createRealMpInstance(Class realMpClass, MessageProcessorId id, Object[] constructorArguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (constructorArguments != null && constructorArguments.length != 0) {
            Class[] classes = this.findConstructorArgumentTypes(realMpClass, constructorArguments);
            if (classes != null) {
                Constructor constructor = realMpClass.getConstructor(classes);
                return constructor.newInstance(constructorArguments);
            }
            this.logger.warn((Object)("The message processor " + id.getFullName() + " has no matching constructor for the offered parameters creating it with default constructor"));
            return realMpClass.newInstance();
        }
        return realMpClass.newInstance();
    }

    private Class getPrimitiveWrapperClass(Class clazz) {
        String primitiveName = clazz.toString();
        if ("boolean".equals(primitiveName)) {
            return Boolean.class;
        }
        if ("byte".equals(primitiveName)) {
            return Byte.class;
        }
        if ("char".equals(primitiveName)) {
            return Character.class;
        }
        if ("double".equals(primitiveName)) {
            return Double.class;
        }
        if ("float".equals(primitiveName)) {
            return Float.class;
        }
        if ("int".equals(primitiveName)) {
            return Integer.class;
        }
        if ("long".equals(primitiveName)) {
            return Long.class;
        }
        if ("short".equals(primitiveName)) {
            return Short.class;
        }
        if ("void".equals(primitiveName)) {
            return Void.class;
        }
        return null;
    }

    private Class[] findConstructorArgumentTypes(Class realMpClass, Object[] constructorArguments) {
        Constructor<?>[] declaredConstructors;
        for (Constructor<?> constructor : declaredConstructors = realMpClass.getDeclaredConstructors()) {
            Class[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != constructorArguments.length) continue;
            boolean mapsCorrectly = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                boolean matchesArgument;
                if (constructorArguments[i] != null) {
                    Class parameterClass = parameterTypes[i].isPrimitive() ? this.getPrimitiveWrapperClass(parameterTypes[i]) : parameterTypes[i];
                    Class constructorArgumentClass = constructorArguments[i].getClass().isPrimitive() ? this.getPrimitiveWrapperClass(constructorArguments[i].getClass()) : constructorArguments[i].getClass();
                    matchesArgument = parameterClass.isAssignableFrom(constructorArgumentClass);
                } else {
                    matchesArgument = true;
                }
                mapsCorrectly &= matchesArgument;
            }
            if (!mapsCorrectly) continue;
            return parameterTypes;
        }
        return null;
    }

    protected Enhancer createEnhancer(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber) {
        Enhancer e = new Enhancer();
        e.setSuperclass(realMpClass);
        e.setUseCache(false);
        e.setAttemptLoad(true);
        e.setInterceptDuringConstruction(true);
        e.setNamingPolicy((NamingPolicy)new MunitNamingPolicy());
        if (FactoryBean.class.isAssignableFrom(realMpClass)) {
            this.createFactoryBeanCallback(id, attributes, fileName, lineNumber, e);
        } else {
            this.createMessageProcessorCallback(id, attributes, fileName, lineNumber, e);
        }
        return e;
    }

    private void createMessageProcessorCallback(MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Enhancer e) {
        MunitMessageProcessorInterceptor callback = new MunitMessageProcessorInterceptor();
        callback.setId(id);
        callback.setAttributes(attributes);
        callback.setFileName(fileName);
        callback.setLineNumber(lineNumber);
        e.setCallbacks(new Callback[]{callback, NULL_METHOD_INTERCEPTOR});
        e.setCallbackFilter(MESSAGE_PROCESSOR_FILTER);
    }

    private void createFactoryBeanCallback(MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Enhancer e) {
        MessageProcessorFactoryBeanInterceptor callback = new MessageProcessorFactoryBeanInterceptor();
        callback.setId(id);
        callback.setAttributes(attributes);
        callback.setFileName(fileName);
        callback.setLineNumber(lineNumber);
        e.setCallbacks(new Callback[]{callback, NULL_METHOD_INTERCEPTOR});
        e.setCallbackFilter(FACTORY_BEAN_FILTER);
    }

    protected MethodInterceptor createInterceptor() {
        return new MunitMessageProcessorInterceptor();
    }

    public Object create(Class realMpClass, Object ... objects) {
        return super.create(realMpClass, objects);
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber) {
        try {
            Enhancer e = this.createEnhancer(realMpClass, id, attributes, fileName, lineNumber);
            return e.create();
        }
        catch (Throwable e) {
            this.logger.warn((Object)("The message processor " + id.getFullName() + " could not be mocked"));
            try {
                return realMpClass.newInstance();
            }
            catch (Throwable e1) {
                throw new Error("The message processor " + id.getFullName() + " could not be created", e);
            }
        }
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object ... constructorArgument) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, constructorArgument);
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument});
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument1, Object constructorArgument2) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument1, constructorArgument2});
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument1, Object constructorArgument2, Object constructorArgument3) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument1, constructorArgument2, constructorArgument3});
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument1, Object constructorArgument2, Object constructorArgument3, Object constructorArgument4) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument1, constructorArgument2, constructorArgument3, constructorArgument4});
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument1, Object constructorArgument2, Object constructorArgument3, Object constructorArgument4, Object constructorArgument5) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument1, constructorArgument2, constructorArgument3, constructorArgument4, constructorArgument5});
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument1, Object constructorArgument2, Object constructorArgument3, Object constructorArgument4, Object constructorArgument5, Object constructorArgument6) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument1, constructorArgument2, constructorArgument3, constructorArgument4, constructorArgument5, constructorArgument6});
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument1, Object constructorArgument2, Object constructorArgument3, Object constructorArgument4, Object constructorArgument5, Object constructorArgument6, Object constructorArgument7) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument1, constructorArgument2, constructorArgument3, constructorArgument4, constructorArgument5, constructorArgument6, constructorArgument7});
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument1, Object constructorArgument2, Object constructorArgument3, Object constructorArgument4, Object constructorArgument5, Object constructorArgument6, Object constructorArgument7, Object constructorArgument8) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument1, constructorArgument2, constructorArgument3, constructorArgument4, constructorArgument5, constructorArgument6, constructorArgument7, constructorArgument8});
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument1, Object constructorArgument2, Object constructorArgument3, Object constructorArgument4, Object constructorArgument5, Object constructorArgument6, Object constructorArgument7, Object constructorArgument8, Object constructorArgument9) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument1, constructorArgument2, constructorArgument3, constructorArgument4, constructorArgument5, constructorArgument6, constructorArgument7, constructorArgument8, constructorArgument9});
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument1, Object constructorArgument2, Object constructorArgument3, Object constructorArgument4, Object constructorArgument5, Object constructorArgument6, Object constructorArgument7, Object constructorArgument8, Object constructorArgument9, Object constructorArgument10) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument1, constructorArgument2, constructorArgument3, constructorArgument4, constructorArgument5, constructorArgument6, constructorArgument7, constructorArgument8, constructorArgument9, constructorArgument10});
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument1, Object constructorArgument2, Object constructorArgument3, Object constructorArgument4, Object constructorArgument5, Object constructorArgument6, Object constructorArgument7, Object constructorArgument8, Object constructorArgument9, Object constructorArgument10, Object constructorArgument11) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument1, constructorArgument2, constructorArgument3, constructorArgument4, constructorArgument5, constructorArgument6, constructorArgument7, constructorArgument8, constructorArgument9, constructorArgument10, constructorArgument11});
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument1, Object constructorArgument2, Object constructorArgument3, Object constructorArgument4, Object constructorArgument5, Object constructorArgument6, Object constructorArgument7, Object constructorArgument8, Object constructorArgument9, Object constructorArgument10, Object constructorArgument11, Object constructorArgument12) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument1, constructorArgument2, constructorArgument3, constructorArgument4, constructorArgument5, constructorArgument6, constructorArgument7, constructorArgument8, constructorArgument9, constructorArgument10, constructorArgument11, constructorArgument12});
    }

    public Object create(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object constructorArgument1, Object constructorArgument2, Object constructorArgument3, Object constructorArgument4, Object constructorArgument5, Object constructorArgument6, Object constructorArgument7, Object constructorArgument8, Object constructorArgument9, Object constructorArgument10, Object constructorArgument11, Object constructorArgument12, Object constructorArgument13) {
        return this.doCreate(realMpClass, id, attributes, fileName, lineNumber, new Object[]{constructorArgument1, constructorArgument2, constructorArgument3, constructorArgument4, constructorArgument5, constructorArgument6, constructorArgument7, constructorArgument8, constructorArgument9, constructorArgument10, constructorArgument11, constructorArgument12, constructorArgument13});
    }

    private Object doCreate(Class realMpClass, MessageProcessorId id, Map<String, String> attributes, String fileName, String lineNumber, Object[] constructorArguments) {
        try {
            Enhancer e = this.createEnhancer(realMpClass, id, attributes, fileName, lineNumber);
            if (constructorArguments != null && constructorArguments.length != 0) {
                Class[] classes = this.findConstructorArgumentTypes(realMpClass, constructorArguments);
                if (classes != null) {
                    return e.create(classes, constructorArguments);
                }
                throw new Error("The message processor " + id.getFullName() + " could not be created, because there is no matching constructor");
            }
            return e.create();
        }
        catch (Throwable e) {
            this.logger.warn((Object)("The message processor " + id.getFullName() + " could not be mocked"));
            try {
                return this.createRealMpInstance(realMpClass, id, constructorArguments);
            }
            catch (Throwable e1) {
                throw new Error("The message processor " + id.getFullName() + " could not be created", e1);
            }
        }
    }
}

