/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.mocking.spy;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.munit.common.mocking.SpyProcess;

import java.util.List;

public class SpyProcessContainer implements MessageProcessor, SpyMessageProcessorContainer {

    private final List<SpyProcess> spyProcesses;

    public SpyProcessContainer(List<SpyProcess> spyProcesses) {
        this.spyProcesses = spyProcesses;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (spyProcesses != null) {
            for (SpyProcess process : spyProcesses) {
                process.spy(event);
            }
        }
        return event;
    }

    @Override
    public Boolean containsMessageProcessors() {
        if (null != spyProcesses && !spyProcesses.isEmpty()) {
            if (!spyProcesses.isEmpty()) {
                if (SpyMessageProcessorContainer.class.isAssignableFrom(spyProcesses.get(0).getClass())) {
                    return ((SpyProcessImpl) spyProcesses.get(0)).containsMessageProcessors();
                } else {
                    // If we can't cast we have to assume it has something
                    return true;
                }
            }
        }
        return false;
    }

}