/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.processor.interceptor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.MuleEvent;
import org.mule.munit.common.processor.interceptor.MessageProcessorAttributeFilter;
import org.mule.util.AttributeEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageProcessorAttributesEvaluator {
    private static final List<String> PAYLOAD_TRANSFORMATION_EXPRESSIONS = Arrays.asList(".*#\\[.*message.payloadAs\\(.*\\].*", ".*#\\[payload:.*\\].*", ".*#\\[dw\\(.*payload.*\\)\\].*");
    private static final List<String> PAYLOAD_ITERATION_EXPRESSIONS = Arrays.asList(".*#\\[.*payload.next\\(\\).*\\].*");

    protected static Map<String, Object> getEvaluatedAttributes(Object originalMp, Map<String, String> attributes, MuleEvent event) {
        Map<String, String> filteredAttributes = MessageProcessorAttributeFilter.filterAttributes(originalMp, attributes);
        HashMap<String, Object> processed = new HashMap<String, Object>();
        for (Map.Entry<String, String> attrs : filteredAttributes.entrySet()) {
            try {
                if (MessageProcessorAttributesEvaluator.shouldEvaluate(event, attrs.getValue())) {
                    Object evaluate = MessageProcessorAttributesEvaluator.evaluate(attrs.getValue(), event);
                    processed.put(attrs.getKey(), evaluate);
                    continue;
                }
                processed.put(attrs.getKey(), attrs.getValue());
            }
            catch (Throwable t) {
                processed.put(attrs.getKey(), attrs.getValue());
            }
        }
        return processed;
    }

    private static boolean shouldEvaluate(MuleEvent event, String value) {
        Object payload = event.getMessage().getPayload();
        return !MessageProcessorAttributesEvaluator.isPayloadStreamTransformation(payload, value) && !MessageProcessorAttributesEvaluator.isIteratorPayloadIteration(payload, value);
    }

    private static boolean isIteratorPayloadIteration(Object payload, String value) {
        return payload instanceof Iterator && MessageProcessorAttributesEvaluator.isPayloadIteration(value);
    }

    private static boolean isPayloadStreamTransformation(Object payload, String value) {
        return payload instanceof XMLStreamReader && MessageProcessorAttributesEvaluator.isPayloadTransformation(value);
    }

    private static boolean isPayloadIteration(String expression) {
        for (String payloadTransformationRegex : PAYLOAD_ITERATION_EXPRESSIONS) {
            if (!Pattern.matches(payloadTransformationRegex, expression)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPayloadTransformation(String expression) {
        for (String payloadTransformationRegex : PAYLOAD_TRANSFORMATION_EXPRESSIONS) {
            if (!Pattern.matches(payloadTransformationRegex, expression)) continue;
            return true;
        }
        return false;
    }

    private static Object evaluate(String elementValue, MuleEvent event) {
        Object o;
        Object compareTo = elementValue;
        AttributeEvaluator attributeEvaluator = MessageProcessorAttributesEvaluator.getAttributeEvaluator(elementValue, event);
        if (attributeEvaluator.isExpression() || attributeEvaluator.isParseExpression()) {
            compareTo = attributeEvaluator.resolveValue(event);
        } else if (!StringUtils.isEmpty((CharSequence)elementValue) && (o = event.getMuleContext().getRegistry().lookupObject(elementValue)) != null) {
            compareTo = o;
        }
        return compareTo;
    }

    private static AttributeEvaluator getAttributeEvaluator(String attributeValue, MuleEvent event) {
        AttributeEvaluator attributeEvaluator = new AttributeEvaluator(attributeValue);
        attributeEvaluator.initialize(event.getMuleContext().getExpressionManager());
        return attributeEvaluator;
    }
}

