/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ReusableByteArrayInputStream
extends ByteArrayInputStream {
    public ReusableByteArrayInputStream(byte[] buf) {
        super(buf);
        this.mark(-1);
    }

    public void close() throws IOException {
        super.close();
        this.reset();
    }

    public static ReusableByteArrayInputStream of(InputStream originalStream) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)originalStream, (OutputStream)outStream);
        originalStream.close();
        return new ReusableByteArrayInputStream(outStream.toByteArray());
    }
}

