/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.mocking.spy;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.munit.common.mocking.SpyProcess;

import java.util.List;

/**
 * Simple implementation of SpyProcess, who knows to process each of the contained message processors.
 *
 */
public class SpyProcessImpl implements SpyProcess, SpyMessageProcessorContainer {
    private List<MessageProcessor> messageProcessorsFrom;

    public SpyProcessImpl(List<MessageProcessor> messageProcessorsFrom) {
        this.messageProcessorsFrom = messageProcessorsFrom;
    }

    @Override
    public void spy(MuleEvent event) throws MuleException {
        for (MessageProcessor mp : messageProcessorsFrom) {
            mp.process(event);
        }
    }

    @Override
    public Boolean containsMessageProcessors() {
        if (null != messageProcessorsFrom && !messageProcessorsFrom.isEmpty()) {
            return messageProcessorsFrom.get(0) != null;
        }
        return false;
    }
}

