/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.cglib.proxy.Enhancer;
import org.mule.api.registry.ResolverException;
import org.mule.api.transformer.Transformer;
import org.mule.registry.TypeBasedTransformerResolver;
import org.mule.transformer.TransformerWeighting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUnitTypeBasedTransformerResolver
extends TypeBasedTransformerResolver {
    protected Transformer getNearestTransformerMatch(List<Transformer> trans, Class input, Class output) throws ResolverException {
        Transformer transformer = null;
        if (trans.size() == 1) {
            transformer = trans.get(0);
        }
        if (trans.size() > 1) {
            this.logger.debug((Object)("Comparing transformers for best match: source = " + input + " target = " + output + " Possible transformers = " + trans));
            List<TransformerWeighting> weightings = this.calculateTransformerWeightings(trans, input, output);
            TransformerWeighting maxWeighting = weightings.get(weightings.size() - 1);
            List<TransformerWeighting> maxWeightings = this.getMaxWeightingTransformers(weightings, maxWeighting);
            transformer = this.getEnhancedByMunit(maxWeightings);
            if (transformer == null) {
                transformer = maxWeightings.get(0).getTransformer();
            }
        }
        return transformer;
    }

    private List<TransformerWeighting> getMaxWeightingTransformers(List<TransformerWeighting> weightings, TransformerWeighting maxWeighting) {
        ArrayList<TransformerWeighting> maxWeightings = new ArrayList<TransformerWeighting>();
        for (TransformerWeighting weighting : weightings) {
            if (maxWeighting.compareTo((Object)weighting) != 0) continue;
            maxWeightings.add(weighting);
        }
        return maxWeightings;
    }

    private Transformer getEnhancedByMunit(List<TransformerWeighting> weightings) {
        for (TransformerWeighting weighting : weightings) {
            if (!Enhancer.isEnhanced(weighting.getTransformer().getClass())) continue;
            return weighting.getTransformer();
        }
        return null;
    }

    private List<TransformerWeighting> calculateTransformerWeightings(List<Transformer> transformers, Class input, Class output) {
        ArrayList<TransformerWeighting> weightings = new ArrayList<TransformerWeighting>(transformers.size());
        for (Transformer transformer : transformers) {
            TransformerWeighting transformerWeighting = new TransformerWeighting(input, output, transformer);
            weightings.add(transformerWeighting);
        }
        Collections.sort(weightings);
        return weightings;
    }
}

