/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyExtractor {
    private static final String EXTRACTION_ERROR_MESSAGE = "Unable to extract class from proxy";
    private static Log logger = LogFactory.getLog(ProxyExtractor.class);

    public static Object extractIfProxy(Object obj) {
        if (obj instanceof Proxy) {
            try {
                Object proxiedClass = ProxyExtractor.extract(obj);
                logger.debug((Object)("Extraction of class " + proxiedClass + " from proxy successful"));
                return proxiedClass;
            }
            catch (NoSuchMethodException e) {
                logger.debug((Object)EXTRACTION_ERROR_MESSAGE, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.debug((Object)EXTRACTION_ERROR_MESSAGE, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.debug((Object)EXTRACTION_ERROR_MESSAGE, (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                logger.debug((Object)EXTRACTION_ERROR_MESSAGE, (Throwable)e);
            }
        }
        return obj;
    }

    private static Object extract(Object obj) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(obj);
        Field advisedField = invocationHandler.getClass().getDeclaredField("advised");
        advisedField.setAccessible(true);
        Object advised = advisedField.get(invocationHandler);
        Method targetSourceMethod = advised.getClass().getMethod("getTargetSource", new Class[0]);
        targetSourceMethod.setAccessible(true);
        Object targetSource = targetSourceMethod.invoke(advised, new Object[0]);
        Field targetField = targetSource.getClass().getDeclaredField("target");
        targetField.setAccessible(true);
        return targetField.get(targetSource);
    }
}

