/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;

/**
 * This is a special implementation of the ByteArrayInputStream.
 * Upon creation the ByteArrayInputStream is marked at the beginning of the array.
 * If the stream is fully consumed or if it is closed then it is automatically resetted.
 */
public class ReusableByteArrayInputStream extends ByteArrayInputStream {

    public ReusableByteArrayInputStream(byte[] buf) {
        super(buf);
        mark(-1);
    }

    @Override
    public void close() throws IOException {
        super.close();
        reset();
    }

    public static ReusableByteArrayInputStream of(InputStream originalStream) throws IOException {
        return new ReusableByteArrayInputStream(IOUtils.toByteArray(originalStream));
    }
}
