/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.el;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.mule.munit.common.el.assertions.MessageHasElementAssertionCommand;
import org.mule.munit.common.el.assertions.functions.ElementMatchingAssertionMelFunction;
import org.mule.munit.common.el.assertions.functions.MessageHasElementAssertionMelFunction;
import org.mule.munit.common.el.assertions.functions.MessageMatchingAssertionMelFunction;
import org.mule.munit.common.el.assertions.matchers.ElementMatcher;
import org.mule.munit.common.el.assertions.matchers.ElementMatcherFactory;
import org.mule.munit.common.interceptor.matchers.mel.AnyClassMatcherFunction;
import org.mule.munit.common.interceptor.matchers.mel.AnyMatcherFunction;
import org.mule.munit.common.interceptor.matchers.mel.ContainsMatcherFunction;
import org.mule.munit.common.interceptor.matchers.mel.EqMatcherFunction;
import org.mule.munit.common.interceptor.matchers.mel.NotNullMatcherFunction;
import org.mule.munit.common.interceptor.matchers.mel.NullMatcherFunction;
import org.mule.munit.common.interceptor.matchers.mel.RegexMatcherFunction;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;
import org.mule.runtime.core.internal.message.InternalMessage;

public class MunitMelConfigurator {

  private MuleContext muleContext;

  public MunitMelConfigurator(MuleContext muleContext) {
    this.muleContext = muleContext;
  }

  public void configure(ExpressionLanguageContext context) {
    // TODO mu-641 provide valid implementation for this
    // context.declareFunction("messageHasPropertyInAnyScopeCalled",
    // new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand() {
    //
    // @Override
    // public boolean messageHas(String param, MuleMessage muleMessage) {
    // boolean contains = false;
    // for (PropertyScope scope : PropertyScope.ALL_SCOPES) {
    // contains = contains || (muleMessage.getProperty(param, scope) != null);
    // }
    // return contains;
    // }
    // }));
    //
    // context.declareFunction("messageHasSessionPropertyCalled",
    // new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand() {
    //
    // @Override
    // public boolean messageHas(String param, MuleMessage muleMessage) {
    // org.mule.runtime.core.api.MuleMessage enhancedMessage = (org.mule.runtime.core.api.MuleMessage)muleMessage;
    //
    // return enhancedMessage.getProperty(param, PropertyScope.SESSION) != null;
    // }
    // }));

    context.declareFunction("messageHasInboundPropertyCalled",
                            new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand() {


                              @Override
                              public boolean messageHas(String param, Message muleMessage) {
                                InternalMessage enhancedMessage = (InternalMessage) muleMessage;
                                return enhancedMessage.getInboundProperty(param) != null;
                              }
                            }));

    context.declareFunction("messageHasOutboundPropertyCalled",
                            new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand() {

                              @Override
                              public boolean messageHas(String param, Message muleMessage) {
                                InternalMessage enhancedMessage = (InternalMessage) muleMessage;
                                return enhancedMessage.getOutboundProperty(param) != null;
                              }
                            }));



    context.declareFunction("messageHasInboundAttachmentCalled",
                            new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand() {

                              @Override
                              public boolean messageHas(String param, Message muleMessage) {
                                InternalMessage enhancedMessage = (InternalMessage) muleMessage;
                                return enhancedMessage.getInboundAttachment(param) != null;
                              }
                            }));

    context.declareFunction("messageHasOutboundAttachmentCalled",
                            new MessageHasElementAssertionMelFunction(new MessageHasElementAssertionCommand() {

                              @Override
                              public boolean messageHas(String param, Message muleMessage) {
                                InternalMessage enhancedMessage = (InternalMessage) muleMessage;
                                return enhancedMessage.getOutboundAttachment(param) != null;
                              }
                            }));

    context.declareFunction("messageInboundProperty", new MessageMatchingAssertionMelFunction(new ElementMatcherFactory() {

      @Override
      public ElementMatcher build(String elementName, Message muleMessage) {
        InternalMessage enhancedMessage = (InternalMessage) muleMessage;
        return new ElementMatcher(((TypedValue) enhancedMessage.getInboundProperty(elementName)).getValue());
      }
    }));

    context.declareFunction("messageOutboundProperty", new MessageMatchingAssertionMelFunction(new ElementMatcherFactory() {

      @Override
      public ElementMatcher build(String elementName, Message muleMessage) {
        InternalMessage enhancedMessage = (InternalMessage) muleMessage;
        return new ElementMatcher(((TypedValue) enhancedMessage.getOutboundProperty(elementName)).getValue());
      }
    }));

    context.declareFunction("messageInboundAttachment", new MessageMatchingAssertionMelFunction(new ElementMatcherFactory() {

      @Override
      public ElementMatcher build(String elementName, Message muleMessage) {
        InternalMessage enhancedMessage = (InternalMessage) muleMessage;
        return new ElementMatcher(enhancedMessage.getInboundAttachment(elementName));
      }
    }));

    context.declareFunction("messageOutboundAttachment", new MessageMatchingAssertionMelFunction(new ElementMatcherFactory() {

      @Override
      public ElementMatcher build(String elementName, Message muleMessage) {
        InternalMessage enhancedMessage = (InternalMessage) muleMessage;
        return new ElementMatcher(enhancedMessage.getOutboundAttachment(elementName));
      }
    }));

    context.declareFunction("valueOf", new ElementMatchingAssertionMelFunction());


    context.declareFunction("eq", new EqMatcherFunction());
    context.declareFunction("anyBoolean", new AnyMatcherFunction(Boolean.class));
    context.declareFunction("anyByte", new AnyMatcherFunction(Byte.class));
    context.declareFunction("anyByteArray", new AnyMatcherFunction(byte[].class));
    context.declareFunction("anyInt", new AnyMatcherFunction(Integer.class));
    context.declareFunction("anyDouble", new AnyMatcherFunction(Double.class));
    context.declareFunction("anyFloat", new AnyMatcherFunction(Float.class));
    context.declareFunction("anyShort", new AnyMatcherFunction(Short.class));
    context.declareFunction("anyObject", new AnyMatcherFunction(Object.class));
    context.declareFunction("anyString", new AnyMatcherFunction(String.class));
    context.declareFunction("anyList", new AnyMatcherFunction(List.class));
    context.declareFunction("anySet", new AnyMatcherFunction(Set.class));
    context.declareFunction("anyMap", new AnyMatcherFunction(Map.class));
    context.declareFunction("anyCollection", new AnyMatcherFunction(Collection.class));
    context.declareFunction("isNull", new NullMatcherFunction());
    context.declareFunction("isNotNull", new NotNullMatcherFunction());
    context.declareFunction("any", new AnyClassMatcherFunction());
    context.declareFunction("matchRegex", new RegexMatcherFunction());
    context.declareFunction("matchContains", new ContainsMatcherFunction());
  }

}
