/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.el.assertions.functions;

import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;
import org.mule.runtime.core.api.el.ExpressionLanguageFunction;

/**
 * <p>
 * Abstract class that represents an MEL function for asserting
 * </p>
 * <p/>
 * <p>
 * This class just contains a method to get the mule message when the function is called.
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.4
 */
public abstract class AssertionMelFunction implements ExpressionLanguageFunction {

  protected Message getMuleMessageFrom(ExpressionLanguageContext context) {
    return context.getVariable("_muleMessage");
  }
}
