/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.el.assertions.functions;

import org.mule.munit.common.el.assertions.matchers.ElementMatcher;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;

/**
 * <p>
 * MEL function to evaluate that an element of the message matches something
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.4
 */
public class ElementMatchingAssertionMelFunction extends AssertionMelFunction {

  @Override
  public Object call(Object[] params, ExpressionLanguageContext context) {
    if (params != null && params.length > 0) {
      Message messageFrom = getMuleMessageFrom(context);

      if (messageFrom == null) {
        throw new RuntimeException("Could not get message;");
      }

      return new ElementMatcher(params[0]);
    }

    throw new IllegalArgumentException("Invalid parameter");
  }

}
