/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.el.utils;

import org.mule.munit.common.el.MunitExpressionFunction;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.core.api.MuleContext;

import java.util.Collections;
import java.util.List;

/**
 * <p>
 * This is an extension that allows you to obtain a bean from the MuleContext by using its name.
 * <p/>
 * <pre>
 *         {@code
 *           <munit:assert-on-equals expectedValue="#[getBeanFromMuleContext('bean_name')]" actualValue="#[payload]"/>
 *         }
 *     </pre>
 * <p>
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.6.0
 */
// TODO Do we still need this function
public class GetBeanFromMuleContextFunction extends MunitExpressionFunction {

  private MuleContext muleContext;

  public GetBeanFromMuleContextFunction(MuleContext muleContext) {
    this.muleContext = muleContext;
  }

  @Override
  public Object call(Object[] params, BindingContext bindingContext) {
    if (params == null || params.length != 1 || !(params[0] instanceof String)) {
      throw new IllegalArgumentException(
                                         "You must provide one parameter that indicates the name of the bean you're looking for");
    }
    String beanName = (String) params[0];
    return muleContext.getRegistry().lookupObject(beanName);
  }

  @Override
  public List<FunctionParameter> parameters() {
    return Collections.singletonList(new FunctionParameter("bean", DataType.STRING));
  }

  @Override
  public String getName() {
    return "getBeanFromMuleContext";
  }
}
