/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.el.utils;

import org.mule.munit.common.el.MunitExpressionFunction;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;

import java.util.Collections;
import java.util.List;

public class GetResourceAsStringFunction extends MunitExpressionFunction {

  @Override
  public Object call(Object[] params, BindingContext bindingContext) {
    return new MunitResource((String) params[0]).asString();
  }

  @Override
  public List<FunctionParameter> parameters() {
    return Collections.singletonList(new FunctionParameter("resource", DataType.STRING));
  }

  @Override
  public String getName() {
    return "getResourceAsString";
  }
}
