/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.el.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;

/**
 * This is a special implementation of the ByteArrayInputStream.
 * Upon creation the ByteArrayInputStream is marked at the beginning of the array.
 * If the stream is fully consumed or if it is closed then it is automatically resetted.
 */
public class ReusableByteArrayInputStream extends ByteArrayInputStream {

  public ReusableByteArrayInputStream(byte[] buf) {
    super(buf);
    mark(-1);
  }

  public ReusableByteArrayInputStream(byte[] buf, int offset, int length) {
    super(buf, offset, length);
    mark(-1);
  }

  @Override
  public synchronized int read() {
    int read = super.read();
    resetIfEnd(read);
    return read;
  }

  @Override
  public synchronized int read(byte[] b, int off, int len) {
    int read = super.read(b, off, len);
    resetIfEnd(read);
    return read;
  }

  @Override
  public void close() throws IOException {
    super.close();
    reset();
  }

  private void resetIfEnd(int read) {
    if (-1 == read) {
      reset();
    }
  }
}
